#pragma once
#include "Stdafx.h"
#include "Messenger.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Runtime::InteropServices;
using namespace System::Text;

namespace ServiceSnapShot {

	// http://www.developer.com/net/cplus/article.php/10919_3510471_2
	delegate BOOL EnumChildWndDelegate(System::IntPtr lpEnumFunc, System::IntPtr lParam);
	delegate BOOL EnumDesktopWndDelegate(System::IntPtr lpEnumFunc, System::IntPtr lParam);
	delegate BOOL EnumThreadWndDelegate(System::IntPtr lpEnumFunc, System::IntPtr lParam);
	delegate BOOL EnumTopLvlWndDelegate(System::IntPtr lpEnumFunc, System::IntPtr lParam);

	[DllImport("user32.dll", SetLastError = true)] 
	extern "C" BOOL EnumChildWindows(System::IntPtr hWnd, ServiceSnapShot::EnumChildWndDelegate^ lpEnumFunc, System::IntPtr lParam); 

	[DllImport("user32.dll", SetLastError = true)] 
	extern "C" BOOL EnumDesktopWindows(ServiceSnapShot::EnumDesktopWndDelegate^ lpEnumFunc, System::IntPtr lParam); 

	[DllImport("user32.dll", SetLastError = true)] 
	extern "C" BOOL EnumThreadWindows(System::UInt32 dwThreadId, ServiceSnapShot::EnumThreadWndDelegate^ lpEnumFunc, System::IntPtr lParam); 

	[DllImport("user32.dll", SetLastError = true)] 
	extern "C" BOOL EnumWindows(ServiceSnapShot::EnumTopLvlWndDelegate^ lpEnumFunc, System::IntPtr lParam); 

	[DllImport("user32.dll", SetLastError = true)] 
	extern "C" INT GetClassName(System::IntPtr hWnd, System::Text::StringBuilder^ className, INT nMaxCount);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" BOOL GetWindowInfo(System::IntPtr hWnd, WINDOWINFO &pWi);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" BOOL GetWindowRect(System::IntPtr hWnd, RECT &lpRect);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT IsWindowEnabled(System::IntPtr hWnd);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT IsWindowVisible(System::IntPtr hWnd);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT SendMessage(System::IntPtr hWnd, INT msg, INT wParam, System::Text::StringBuilder^ lParam);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT SendMessageTimeout(System::IntPtr hWnd, INT msg, INT wParam, System::Text::StringBuilder^ lParam, INT fuFlags, INT uTimeout, PDWORD_PTR lpdwResult);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT SetWindowPos(System::IntPtr hWnd, System::IntPtr hWndAfter, System::Int32 x, System::Int32 y, System::Int32 cx, System::Int32 cy, System::UInt32 uFlags);

	/// <summary>
	/// Summary for Collection
	/// </summary>
	public ref class Collection :  public System::ComponentModel::Component
	{
	public:
		Collection(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Collection(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

			try
			{
				evtEntry->Append(Environment::NewLine + "Polling interval is " + config->daemonizepollinginterval);
				evtEntry->Append(Environment::NewLine + "Garbage collection interval is " + config->daemonizegarbagecollectioninterval);
				evtEntry->Append(Environment::NewLine);

				System::Collections::ArrayList^ pmap = Shared::XML::SnapShot::Reader::ProcessesAvailableConfig();

				for each(System::String^ pkey in pmap)
				{
					evtEntry->Append(Environment::NewLine + pkey);
				}

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->collectiondaemonize);

				for( ; ; )
				{
					// Pause thread execution for polling interval.
					System::Threading::Thread::Sleep(config->daemonizepollinginterval);
					evtEntry = gcnew StringBuilder();

					// Enumerate map object hashtable to see what processes we should watch for.
					for each(System::String^ pkey in pmap)
					{
						System::Collections::ArrayList^ plist = gcnew System::Collections::ArrayList();
						ServiceSnapShot::Collection::SearchProcessesByName(pkey, plist);

						for each(System::String^ pid in plist)
						{
							ServiceSnapShot::Collection::HeartBeatForProcess(System::UInt32::Parse(pid), pkey);

							System::Collections::ArrayList^ tlist = gcnew System::Collections::ArrayList();
							ServiceSnapShot::Collection::SearchThreadsByPid(System::UInt32::Parse(pid), tlist);

							for each(System::String^ tid in tlist)
							{
								System::Collections::ArrayList^ twndlist = gcnew System::Collections::ArrayList();
								ServiceSnapShot::Collection::SearchThreadWnd(System::UInt32::Parse(tid), twndlist);

								for each(System::String^ twnd in twndlist)
								{
									ServiceSnapShot::Collection::HeartBeatForGame(System::UInt32::Parse(pid), System::IntPtr(System::Int32::Parse(twnd)));
								}
							}
						}
					}
					// Initialize list of processes to be removed from collection.
					System::Collections::ArrayList^ sprocesses = gcnew System::Collections::ArrayList();

					// Lock the object for thread safe iteration.
					msclr::lock plock(Private::SnapShot::Globals::collection->SyncRoot);
					plock.acquire();

					// Identify stale processes within collection...
					for each(System::Object^ pkey in Private::SnapShot::Globals::collection->Keys)
					{
						Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[pkey];

						// Initialize list of clients to be removed from collection.
						System::Collections::ArrayList^ sclients = gcnew System::Collections::ArrayList();

						// Lock the object for thread safe iteration.
						msclr::lock glock(process->clients->SyncRoot);
						glock.acquire();

						for each(System::Object^ gkey in process->clients->Keys)
						{
							Private::SnapShot::Objects::Client^ client = (Private::SnapShot::Objects::Client^)process->clients[gkey];

							// Identify stale clients within collection...
							if((System::DateTime::Now.Ticks - client->timestamp.Ticks) > (config->daemonizegarbagecollectioninterval * 10000))
							{
								// Log the event.
								evtEntry = gcnew System::Text::StringBuilder(L"ServiceSnapShot::Collection::Daemonize()" + Environment::NewLine);
								evtEntry->Append(Environment::NewLine + "Deleted Client " + client->hwnd.ToString() + " \"" + client->caption + "\"");
								evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Information, log->collectiondaemonize);

								// Add hashtable index to list of clients to be deleted.
								sclients->Add(gkey);

								Shared::SnapShot::Messages::Client^ message = gcnew Shared::SnapShot::Messages::Client("HEARTBEAT", process->pid, client->hwnd, client->type, System::String::Empty);
								ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
							}
						}
						// Delete stale clients from hashtable.
						// Cannot be done while interating through hashtable.
						for each(System::Object^ gkey in sclients)
						{
							process->clients->Remove(gkey);
						}

						// Delete client stale process objects...
						if((System::DateTime::Now.Ticks - process->timestamp.Ticks) > (config->daemonizegarbagecollectioninterval * 10000))
						{
							// Log the event.
							evtEntry = gcnew System::Text::StringBuilder(L"ServiceSnapShot::Collection::Daemonize()" + Environment::NewLine);
							evtEntry->Append(Environment::NewLine + "Deleted pid " + process->pid + " \"" + process->name + "\"");
							evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Information, log->collectiondaemonize);

							// Add hashtable index to list of processes to be deleted.
							sprocesses->Add(pkey);

							Shared::SnapShot::Messages::Process^ message = gcnew Shared::SnapShot::Messages::Process("HEARTBEAT", process->pid);
							message->name = System::String::Empty;
							ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
						}

						// Release lock on the object.
						glock.release();
					}
					// Delete stale processes from hashtable.
					// Cannot be done while interating through hashtable.
					for each(System::Object^ pkey in sprocesses)
					{
						Private::SnapShot::Globals::collection->Remove(pkey);
					}

					// Release lock on the object.
					plock.release();
				}
			}
			// http://msdn.microsoft.com/en-us/library/tttdef8x.aspx
			catch(System::Threading::ThreadInterruptedException^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->collectiondaemonize);
				evtLog->Close();
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectiondaemonize);
				evtLog->Close();
			}
			finally
			{
				evtLog->Close();
			}
		}
		static void HeartBeatForGame(System::UInt32 pid, System::IntPtr hwnd)
		{
			try
			{
				// Verify the process object exists in hashtable.
				if(Private::SnapShot::Globals::collection->ContainsKey(pid.ToString()))
				{
					Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[pid.ToString()];

					// Verify the client object exists in hashtable.
					if(process->clients->ContainsKey(hwnd.ToString()))
					{
						Private::SnapShot::Objects::Client^ client = (Private::SnapShot::Objects::Client^)process->clients[hwnd.ToString()];
						System::Collections::Hashtable^ gchwnd = gcnew System::Collections::Hashtable();
						
						Shared::SnapShot::Messages::Client^ message = gcnew Shared::SnapShot::Messages::Client("HEARTBEAT", process->pid, client->hwnd, client->type, client->caption);
						ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);

						// Enumerate all window controls.
						ServiceSnapShot::Collection::SearchChildWnd(client->hwnd, gchwnd);

						// Lock the object for thread safe iteration.
						msclr::lock llock(client->layout->SyncRoot);
						llock.acquire();

						for each (System::Object^ lkey in gchwnd->Keys)
						{
							// Assign updated value to element in hashtable.
							if(client->layout->ContainsKey(lkey))
							{
								// http://msdn.microsoft.com/en-us/library/ms646303(VS.85).aspx
								if(IsWindowVisible(((Private::SnapShot::Objects::Element^)gchwnd[lkey])->chwnd) 
									&& IsWindowEnabled(((Private::SnapShot::Objects::Element^)gchwnd[lkey])->chwnd))
								{
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter = "CLIENT";
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->chwnd;
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->xy;
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->value = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->value;
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->timestamp = DateTime::Now;

									if(client->allowmonitor)
									{
										Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, lkey->ToString());
										message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter;
										message->id = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->id;
										message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd;
										message->xy = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy->ToString();
										message->value = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->value;
										ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
									}
								}
							}

							if(Private::SnapShot::Globals::windowdebug.Equals(true))
							{
								Private::SnapShot::Objects::Debugger^ debug = gcnew Private::SnapShot::Objects::Debugger("CLIENT", process->pid.ToString(), client->hwnd.ToString(), lkey->ToString());
								debug->chwnd = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->chwnd.ToString();
								debug->xy = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->xy->ToString();
								debug->value = ((Private::SnapShot::Objects::Element^)gchwnd[lkey])->value;
								debug->timestamp = DateTime::Now.ToString();
								Private::SnapShot::Globals::diagnostic->Enqueue((System::Object^)debug);
							}
						}

						for each(System::Object ^lkey in client->layout->Keys)
						{
							Private::SnapShot::Objects::Element^ element = (Private::SnapShot::Objects::Element^)client->layout[lkey];
							
							if(element->reporter->Equals("TRAMPOLINE"))
							{
								if((System::DateTime::Now.Ticks - element->timestamp.Ticks) > (config->daemonizegarbagecollectioninterval * 30000))
								{
									// Assign updated value to element in hashtable.
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->value = System::String::Empty;

									if(client->allowmonitor)
									{
										Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, lkey->ToString());
										message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter;
										message->id = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->id;
										message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd;
										message->xy = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy->ToString();
										message->value = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->value;
										ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
									}
								}
							}
							else if(element->reporter->Equals("PHOTOGRAPH"))
							{
								if((System::DateTime::Now.Ticks - element->timestamp.Ticks) > (config->daemonizegarbagecollectioninterval * 10000))
								{
									// Assign updated value to element in hashtable.
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->value = System::String::Empty;

									if(client->allowmonitor)
									{
										Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, lkey->ToString());
										message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter;
										message->id = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->id;
										message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd;
										message->xy = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy->ToString();
										message->value = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->value;
										ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
									}
								}
							}
							else if(element->reporter->Equals("CLIENT"))
							{
								if((System::DateTime::Now.Ticks - element->timestamp.Ticks) > (config->daemonizegarbagecollectioninterval * 10000))
								{
									// Assign updated value to element in hashtable.
									((Private::SnapShot::Objects::Element^)client->layout[lkey])->value = System::String::Empty;

									if(client->allowmonitor)
									{
										Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, lkey->ToString());
										message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter;
										message->id = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->id;
										message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd;
										message->xy = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy->ToString();
										message->value = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->value;
										ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
									}
								}
							}
						}

						// Release lock on the object.
						llock.release();

						RECT w;
						GetWindowRect(client->hwnd, w);
						w.right -= w.left;
						w.bottom -= w.top;

						// We have to check the window size because all of our elements are indexed by relative coordinates.
						if(!client->xy->x1.Equals(0) || !client->xy->y1.Equals(0) || !client->xy->x2.Equals(w.right) || !client->xy->y2.Equals(w.bottom))
						{
							// Verify this is a window that is allowed to be adjusted.
							if(client->allowresize)
							{
								// Ensure windows is correct size so all of our known relative coordinates are valid.
								SetWindowPos(client->hwnd, System::IntPtr::Zero, 0, 0, client->xy->x2, client->xy->y2, SWP_NOMOVE);

							}
						}

						// Update timestamp on client object.
						client->timestamp = DateTime::Now;
					}
					// Game not found, create one and bind an attribute map to it.
					else
					{		
						// Send message to hWnd asking for caption length.
						INT length = SendMessage(hwnd, WM_GETTEXTLENGTH, 0, gcnew StringBuilder());

						// Instantiate a buffer large enough to hold text that will be returned.
						StringBuilder^ caption = gcnew StringBuilder(length + 1);

						// Allocate buffer space & send message to hWnd to copy caption to buffer.
						INT result = SendMessage(hwnd, WM_GETTEXT, length + 1, caption);

						// Get layouts available for this process.
						System::Collections::Hashtable^ layouts = Shared::XML::SnapShot::Reader::LayoutsAvailableConfig(process->name);

						for each(System::Object^ key in layouts->Keys)
						{
							// If keyword is found in window caption, bind it to corresponding layout.
							if(RegularExpressions::Regex::IsMatch(caption->ToString(), (System::String^)layouts[key], RegularExpressions::RegexOptions::IgnoreCase | RegularExpressions::RegexOptions::Compiled))
							{
								// Create client object with needed layout information.
								Private::SnapShot::Objects::Client^ client = gcnew Private::SnapShot::Objects::Client(hwnd, caption->ToString()->Trim());
								client->type = (System::String^)layouts[key];
								client->layout = (System::Collections::Hashtable^)Shared::XML::SnapShot::Reader::LayoutConfig(process->name, (System::String^)layouts[key]);
								client->lookup = (System::Collections::Hashtable^)Shared::XML::SnapShot::Reader::LookupConfig(process->name, (System::String^)layouts[key]);
								client->xy = Shared::XML::SnapShot::Reader::SizeConfig(process->name, (System::String^)layouts[key]);
								client->allowresize = Shared::XML::SnapShot::Reader::AllowAutoReSizeConfig(process->name, (System::String^)layouts[key]);

								RECT w;
								GetWindowRect(client->hwnd, w);
								w.right -= w.left;
								w.bottom -= w.top;

								// Log the event.
								StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::HeartBeatForGame()" + Environment::NewLine);
								EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
								evtEntry->Append(Environment::NewLine + "Known dimensions (" + client->xy->ToString() + ")");
								evtEntry->Append(Environment::NewLine + "Perceived dimensions (0:0:" + w.right + ":" + w.bottom + ")");

								// We have to check the window size because all of our elements are indexed by relative coordinates.
								if(!client->xy->x1.Equals(0) || !client->xy->y1.Equals(0) || !client->xy->x2.Equals(w.right) || !client->xy->y2.Equals(w.bottom))
								{
									// Verify this is a window that is allowed to be adjusted.
									if(client->allowresize)
									{
										// Ensure windows is correct size so all of our known relative coordinates are valid.
										SetWindowPos(client->hwnd, System::IntPtr::Zero, 0, 0, client->xy->x2, client->xy->y2, SWP_NOMOVE);
									}

									evtEntry->Append(Environment::NewLine);
									evtEntry->Append(Environment::NewLine + "Cannot add window " + client->hwnd.ToString() + " \"" + client->caption->ToString() + "\"");
									evtEntry->Append(Environment::NewLine);
									evtEntry->Append(Environment::NewLine + "This window has the wrong perceived dimensions. Attempted to adjust window dimensions.");
									evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->collectionheartbeatforclient);
								}
								else
								{
									// Add to client hashtable in process.
									process->clients->Add(hwnd.ToString(), client);

									evtEntry->Append(Environment::NewLine);
									evtEntry->Append(Environment::NewLine + "Added window " + client->hwnd.ToString() + " \"" + client->caption->ToString() + "\"");
									evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Information, log->collectionheartbeatforclient);
								}

								evtLog->Close();

								// Found a layout for window, no need to continue iteration.
								break;
							}
						}
					}
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::HeartBeatForGame()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionheartbeatforclient);
				evtLog->Close();
			}
		}
		static void HeartBeatForProcess(System::UInt32 pid, System::String^ pname)
		{
			try
			{
				// Lock the object for thread safe iteration.
				msclr::lock plock(((System::Collections::Hashtable^)Private::SnapShot::Globals::collection)->SyncRoot);
				plock.acquire();

				// Verify the process object exists in hashtable.
				if(Private::SnapShot::Globals::collection->ContainsKey(pid.ToString()))
				{
					Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[pid.ToString()];

					// Update process object timestamp.
					process->timestamp = DateTime::Now;

					Shared::SnapShot::Messages::Process^ message = gcnew Shared::SnapShot::Messages::Process("HEARTBEAT", pid);
					message->name = process->name;
					ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
				}
				// Create new process object & add to hashtable.
				else
				{
					Private::SnapShot::Objects::Process^ process = gcnew Private::SnapShot::Objects::Process(pid, pname);
					
					// Add to process hashtable.
					Private::SnapShot::Globals::collection->Add(pid.ToString(), process);

					// Log the event.
					StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::HeartBeatForProcess()" + Environment::NewLine);
					EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
					evtEntry->Append(Environment::NewLine + "Added pid " + pid + " \"" + pname + "\"");
					evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Information, log->collectionheartbeatforprocess);
					evtLog->Close();
				}

				// Release lock on the object.
				plock.release();
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::HeartBeatForProcess()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionheartbeatforprocess);
				evtLog->Close();
			}
		}
		static void HeartBeatForTrampoline(System::UInt32 pid, System::IntPtr hwnd, System::IntPtr chwnd, System::String^ api, System::String^ xy, System::String^ value)
		{
			try
			{
				// Verify the process object exists in hashtable.
				if(Private::SnapShot::Globals::collection->ContainsKey(pid.ToString()))
				{
					Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[pid.ToString()];

					// Verify the client object exists in hashtable.
					if(process->clients->ContainsKey(hwnd.ToString()))
					{
						Private::SnapShot::Objects::Client^ client = (Private::SnapShot::Objects::Client^)process->clients[hwnd.ToString()];

						// Lock the object for thread safe iteration.
						msclr::lock glock(process->clients->SyncRoot);
						glock.acquire();

						if(client->layout->ContainsKey(xy->GetHashCode()))
						{				
							if(((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->value != value
								|| ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->chwnd != chwnd)
							{
								// Assign updated value to element in hashtable.
								((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->reporter = "TRAMPOLINE";
								((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->timestamp = DateTime::Now;
								((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->chwnd = chwnd;
								((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->value = value;

								if(client->allowmonitor)
								{
									Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, xy->GetHashCode().ToString());
									message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->reporter;
									message->id = ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->id;
									message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->chwnd;
									message->xy = ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->xy->ToString();
									message->value = ((Private::SnapShot::Objects::Element^)client->layout[xy->GetHashCode()])->value;
									ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
								}
							}
						}

						if(Private::SnapShot::Globals::trampolinedebug.Equals(true))
						{
							Private::SnapShot::Objects::Debugger^ debug = gcnew Private::SnapShot::Objects::Debugger("TRAMPOLINE", process->pid.ToString(), client->hwnd.ToString(), xy->GetHashCode().ToString());

							debug->chwnd = chwnd.ToString();
							debug->api = api;
							debug->xy = xy;
							debug->value = value;
							debug->timestamp = DateTime::Now.ToString();

							Private::SnapShot::Globals::diagnostic->Enqueue((System::Object^)debug);
						}

						// Release lock on the object.
						glock.release();
					}
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::HeartBeatForTrampoline()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionheartbeatfortrampoline);
				evtLog->Close();
			}
		}
		static BOOL SearchTopLvlWnd(System::Collections::ArrayList^ &tlResult)
		{
			topLvlWnd = tlResult;

			EnumTopLvlWndDelegate^ callback = gcnew EnumTopLvlWndDelegate(EnumTopLvlWndProc);
			EnumWindows(callback, System::IntPtr::Zero);

			return(TRUE);
		}
		static BOOL SearchThreadWnd(System::UInt32 thread, System::Collections::ArrayList^ &wResult)
		{
			threadWnd = wResult;

			EnumThreadWndDelegate^ callback = gcnew EnumThreadWndDelegate(EnumThreadWndProc);
			EnumThreadWindows(thread, callback, System::IntPtr::Zero);

			return(TRUE);
		}
		static BOOL SearchChildWnd(System::IntPtr phwnd, System::Collections::Hashtable^ &cResult)
		{
			phWnd = phwnd;
			childWnd = cResult;

			EnumChildWndDelegate^ callback = gcnew EnumChildWndDelegate(EnumChildWndProc);
			EnumChildWindows(phWnd, callback, System::IntPtr::Zero);

			return(TRUE);
		}
		// http://msdn.microsoft.com/en-us/library/ms686701(VS.85).aspx
		static BOOL SearchProcessesByName(System::String^ pbTargetProcess, System::Collections::ArrayList^ &pResult)
		{
			// Declare needed structures for process enumeration.
			PROCESSENTRY32 p;
			HANDLE hProcessSnap = INVALID_HANDLE_VALUE;
			HANDLE hProcess = INVALID_HANDLE_VALUE;

			// Take process snapshot from system.
			hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);

			// If no snapshot is taken... exit.
			if (hProcessSnap == INVALID_HANDLE_VALUE)
			{
				//Console.WriteLine("Unable to create process snapshot!");
				return(FALSE);
			}

			// Remember to initialize the PROCESSENTRY32 structure.
			p.dwSize = sizeof(PROCESSENTRY32);
			BOOL pRslt = Process32First(hProcessSnap, &p);

			// Iterate through the process list.
			while(pRslt != FALSE)
			{
				// Check if process module filename is...
				System::String^ pbExecutable = gcnew System::String(p.szExeFile);

				pbExecutable = pbExecutable->Trim()->ToLower();
				pbTargetProcess = pbTargetProcess->Trim()->ToLower();

				if (pbExecutable->Equals(pbTargetProcess)) 
				{
					pResult->Add(System::UInt32(p.th32ProcessID).ToString());
				}

				pRslt = Process32Next(hProcessSnap, &p);
			}

			// Close the snapshot handle to avoid memory leaks.
			CloseHandle(hProcessSnap);

			return(TRUE);
		}
		static BOOL SearchThreadsByPid(System::UInt32 pid, System::Collections::ArrayList^ &tResult)
		{
			// Declare needed structures for thread enumeration.
			THREADENTRY32 t;
			HANDLE hThreadSnap;

			// Take thread snapshot from system.
			hThreadSnap = CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, 0);

			// If no snapshot is taken... exit.
			if (hThreadSnap == INVALID_HANDLE_VALUE)
			{
				return(FALSE);
			}

			// Remember to initialize the THREADENTRY32 structure.
			t.dwSize = sizeof(THREADENTRY32);
			BOOL tRslt = Thread32First(hThreadSnap, &t);

			// Iterate through the thread list.
			while(tRslt != FALSE)
			{
				// Found another thread.
				tRslt = Thread32Next(hThreadSnap, &t);

				if(pid.Equals(t.th32OwnerProcessID))
				{
					tResult->Add(System::UInt32(t.th32ThreadID).ToString());
				}
			}

			// Close the snapshot handle to avoid memory leaks.
			CloseHandle(hThreadSnap);

			return(TRUE);
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		static BOOL EnumChildWndProc(System::IntPtr chWnd, System::IntPtr lParam)
		{
			// http://msdn.microsoft.com/en-us/library/ms632610(VS.85).aspx
			try
			{
				WINDOWINFO c, p;
				GetWindowInfo(chWnd, c);
				GetWindowInfo(phWnd, p);

				// Subtract parent window coordinate (includes border) from child window coordinate to get relative location.
				c.rcClient.left -= p.rcWindow.left;
				c.rcClient.top -= p.rcWindow.top;
				c.rcClient.right -= p.rcWindow.left;
				c.rcClient.bottom -= p.rcWindow.top;

				// Send message to hWnd asking for caption length.
				INT length = SendMessage(chWnd, WM_GETTEXTLENGTH, 0, gcnew StringBuilder());

				// Instantiate a buffer large enough to hold text that will be returned.
				StringBuilder^ value = gcnew StringBuilder(length + 1);

				// Allocate buffer space & send message to hWnd to copy caption to buffer.
				INT results = SendMessage(chWnd, WM_GETTEXT, length + 1, value);

				// Assign relative coordinates for control within client window.
				Private::SnapShot::Objects::XY^ xy = gcnew Private::SnapShot::Objects::XY(c.rcClient.left, c.rcClient.top, c.rcClient.right, c.rcClient.bottom);
				Private::SnapShot::Objects::Element^ element = gcnew Private::SnapShot::Objects::Element(xy);

				// Assign handle for control of window.
				element->chwnd = chWnd;

				// Assign current displayed value for control in client window.
				element->value = value->ToString();

				// Clear out any chars that aren't worth printing out.
				Private::SnapShot::Filter::NonPrintableASCII(element->value);

				// TEMPORARY, STILL GETTING HASHTABLE COLLISIONS!!!
				if(!childWnd->ContainsKey(element->xy->ToString()->GetHashCode()))
				{
					childWnd->Add(element->xy->ToString()->GetHashCode(), element);
				}
			}
			catch(System::Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::EnumChildWndProc()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionenumchildwndproc);
				evtLog->Close();

				// Return true so subsequent callbacks continue.
				return(TRUE);
			}

			return(TRUE);
		}
		static BOOL EnumThreadWndProc(System::IntPtr chWnd, System::IntPtr lParam)
		{
			try
			{
				StringBuilder^ wndClassName = gcnew StringBuilder(config->enumthreadwndprocbuffersize + 1);
				StringBuilder^ wndText = gcnew StringBuilder(config->enumthreadwndprocbuffersize + 1);
				INT wndClassRtrn;
				INT wndTextLength;
				INT wndTextRtrn;

				// Allocate for wide character count plus terminal null.
				wndClassRtrn = GetClassName(chWnd, wndClassName, config->enumthreadwndprocbuffersize + 1);

				// Send message to hWnd asking for caption length.
				wndTextLength = SendMessage(chWnd, WM_GETTEXTLENGTH, 0, gcnew StringBuilder());

				// Allocate buffer space & send message to hWnd to copy caption to buffer.
				wndTextRtrn = SendMessage(chWnd, WM_GETTEXT, (wndTextLength + 1), wndText);

				if (IsWindowVisible(chWnd) != FALSE) 
				{
					threadWnd->Add(chWnd.ToString());
				}
			}
			catch(System::Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::EnumThreadWndProc()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionenumthreadwndproc);
				evtLog->Close();

				// Return true so subsequent callbacks continue.
				return(TRUE);
			}

			return(TRUE);
		}
		static BOOL EnumTopLvlWndProc(System::IntPtr chWnd, System::IntPtr lParam)
		{
			try
			{
				StringBuilder^ wndClassName;
				StringBuilder^ wndText;
				INT wndClassRtrn;
				INT wndTextLength;
				INT wndTextRtrn;

				wndClassName = gcnew StringBuilder(config->enumtoplvlwndprocbuffersize + 1);

				// Allocate for wide character count plus terminal null.
				wndClassRtrn = GetClassName(chWnd, wndClassName, config->enumtoplvlwndprocbuffersize);

				// Send message to hWnd asking for caption length.
				wndTextLength = SendMessage(chWnd, WM_GETTEXTLENGTH, 0, gcnew StringBuilder());

				wndText = gcnew StringBuilder(wndTextLength + 1);

				// Allocate buffer space & send message to hWnd to copy caption to buffer.
				wndTextRtrn = SendMessage(chWnd, WM_GETTEXT, (wndTextLength + 1), wndText);

				if (IsWindowVisible(chWnd) != FALSE) 
				{
					topLvlWnd->Add(chWnd.ToString() + L"|" + wndText->ToString());
				}
			}
			catch(System::Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Collection::EnumTopLvlWndProc()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectionenumtoplvlwndproc);
				evtLog->Close();

				// Return true so subsequent callbacks continue.
				return(TRUE);
			}

			return(TRUE);
		}
		~Collection()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::SnapShot::Objects::Service::Collection^ config = Shared::XML::SnapShot::Reader::CollectionConfig();
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		static System::Collections::ArrayList^ topLvlWnd;
		static System::Collections::ArrayList^ threadWnd;
		static System::Collections::Hashtable^ childWnd;
		static System::IntPtr phWnd;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
