#pragma once
#include "Stdafx.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::Text;

// http://www.codeproject.com/KB/system/ScreenMonitor.aspx
namespace ServiceSnapShot {
	/// <summary>
	/// Summary for Impersonate
	/// </summary>
	public ref class Impersonate :  public System::ComponentModel::Component
	{
	public:
		Impersonate(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Impersonate(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		// http://www.experts-exchange.com/Programming/Programming_Platforms/Win_Prog/Q_20788246.html
		HANDLE GetCurrentConsoleUserSecurityToken()
		{
			HANDLE hToken;
			TOKEN_USER oUser[16];
			DWORD u32Needed;
			TCHAR sUserName[256], domainName[256];
			DWORD userNameSize, domainNameSize;
//			SID_NAME_USE sidType;

			ZeroMemory(oUser, sizeof(oUser));

			OpenProcessToken(GetExplorerProcessHandle(), TOKEN_QUERY, &hToken);

			GetTokenInformation(hToken, TokenUser, &oUser[0], sizeof(oUser), &u32Needed);

			userNameSize = sizeof(sUserName) - 1;
			domainNameSize = sizeof(domainName) - 1;
		            
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Impersonate::GetCurrentConsoleUserSecurityToken()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");	
/*
			if(!LookupAccountSid(NULL, oUser[0].User.Sid, sUserName, &userNameSize, domainName, &domainNameSize, &sidType))
			{
				evtEntry->Append(Environment::NewLine + L"LookupAccountSid(" 
					+ gcnew System::String("NULL") + ", "
					+ gcnew System::String(oUser[0].User.Sid) + ", "
					+ gcnew System::String(sUserName) + ", "
					+ gcnew System::String(userNameSize) + ", "
					+ gcnew System::String(domainName) /* + ", "
					+ gcnew System::String(domainNameSize) + ", "
					+ gcnew System::String(sidType) + ") failed. Cannot impersonate user.");

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::FailureAudit, log->impersonategetcurrentconsoleusersecuritytoken);
			}
			else
			{
				evtEntry->Append(Environment::NewLine + L"LookupAccountSid(" 
					+ gcnew System::String("NULL") + ", "
					+ gcnew System::String(oUser[0].User.Sid) + ", "
					+ gcnew System::String(sUserName) + ", "
					+ gcnew System::String(userNameSize) + ", "
					+ gcnew System::String(domainName) /* + ", "
					+ gcnew System::String(domainNameSize) + ", "
					+ gcnew System::String(sidType) + ") succeeded.");

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->impersonategetcurrentconsoleusersecuritytoken);
			}
*/
			evtLog->Close();

			return hToken;
		}
		// Needed to impersonate the logged in user... Apparently, the most reliable way to do this is to enumerate all processes & pick out 
		// the "explorer.exe" process, then pop it open & check for user info within.
		HANDLE GetExplorerProcessHandle()
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Impersonate::GetExplorerProcessHandle()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");	

			HANDLE hSnapshot = NULL, hProcess = NULL;
			PROCESSENTRY32 pe32;

			ZeroMemory(&pe32, sizeof(pe32));
			pe32.dwSize = sizeof(PROCESSENTRY32); 

			hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, NULL);

			if(Process32First(hSnapshot, &pe32))
			{
				  do
				  {
						if(!strcmp(pe32.szExeFile, "explorer.exe"))
						{
							  hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID); 
							  break;
						}
				  } while(Process32Next(hSnapshot, &pe32));
			}

			evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->impersonategetexplorerprocesshandle);

			return hProcess;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Impersonate()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
