#pragma once
#include "Stdafx.h"
#include "Messenger.h"
#include "Collection.h"
#include "Debugger.h"
#include "Trampoline.h"
#include "Photograph.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::ServiceProcess;
using namespace System::Threading;
using namespace System::Text;

namespace ServiceSnapShot {

	/// <summary>
	/// Summary for ServiceSnapShotWinService
	/// </summary>
	///
	/// WARNING: If you change the name of this class, you will need to change the
	///          'Resource File Name' property for the managed resource compiler tool
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	public ref class ServiceSnapShotWinService : public System::ServiceProcess::ServiceBase
	{
	public:
		// http://msdn.microsoft.com/en-us/library/system.threading.threadstart.aspx
		System::Threading::ThreadStart^ CollectionDelegate;
		System::Threading::Thread^ CollectionThread;

		System::Threading::ThreadStart^ DebuggerDelegate;
		System::Threading::Thread^ DebuggerThread;

		System::Threading::ThreadStart^ MessengerDelegate;
		System::Threading::Thread^ MessengerThread;

		System::Threading::ThreadStart^ PhotographDelegate;
		System::Threading::Thread^ PhotographThread;

		System::Threading::ThreadStart^ TrampolineDelegate;
		System::Threading::Thread^ TrampolineThread;
		
		ServiceSnapShotWinService()
		{
			InitializeComponent();

			CollectionDelegate = gcnew System::Threading::ThreadStart(&ServiceSnapShot::Collection::Daemonize);
			CollectionThread = gcnew System::Threading::Thread(CollectionDelegate);

			DebuggerDelegate = gcnew System::Threading::ThreadStart(&ServiceSnapShot::Debugger::Daemonize);
			DebuggerThread = gcnew System::Threading::Thread(DebuggerDelegate);

			MessengerDelegate = gcnew System::Threading::ThreadStart(gcnew ServiceSnapShot::Messenger(), &ServiceSnapShot::Messenger::Daemonize);
			MessengerThread = gcnew System::Threading::Thread(MessengerDelegate);

			PhotographDelegate = gcnew System::Threading::ThreadStart(&ServiceSnapShot::Photograph::Daemonize);
			PhotographThread = gcnew System::Threading::Thread(PhotographDelegate);

			TrampolineDelegate = gcnew System::Threading::ThreadStart(&ServiceSnapShot::Trampoline::Daemonize);
			TrampolineThread = gcnew System::Threading::Thread(TrampolineDelegate);
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~ServiceSnapShotWinService()
		{
			if (components)
			{
				delete components;
			}
		}
		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		virtual void OnStart(array<String^>^ args) override
		{
			// TODO: Add code here to start your service.
			CollectionThread->Start();
			DebuggerThread->Start();
			MessengerThread->Start();
			PhotographThread->Start();
			TrampolineThread->Start();
		}
		/// <summary>
		/// Stop this service.
		/// </summary>
		virtual void OnStop() override
		{
			// TODO: Add code here to perform any tear-down necessary to stop your service.
			TrampolineThread->Interrupt();
			PhotographThread->Interrupt();
			MessengerThread->Interrupt();
			DebuggerThread->Interrupt();
			CollectionThread->Interrupt();
		}
	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			// ServiceSnapShotWinService
			this->ServiceName = L"Ludus SnapShot";
		}
#pragma endregion
	};
}
