// Stdafx.h : include file for standard system include files,
// or project specific include files that are used frequently, but
// are changed infrequently
#pragma once

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <windows.h>
#include <tlhelp32.h>

#pragma warning(disable:4091)	// http://social.msdn.microsoft.com/forums/en-US/vclanguage/thread/239841ca-ab90-4cc6-978f-193411823890/
#include <msclr\lock.h>			// http://msdn.microsoft.com/en-us/library/ms177086(VS.80).aspx
#pragma warning(default:4091)

#define TRAMPOLINE_BUFFERSIZE 4096
#define TRAMPOLINE_INSTANCES 64 
#define TRAMPOLINE_CONNECTINGSTATE 0
#define TRAMPOLINE_READINGSTATE 1 
#define TRAMPOLINE_WRITINGSTATE 2 

typedef struct 
{ 
	OVERLAPPED oOverlap; 
	HANDLE hPipeInst; 
	CHAR chRequest[TRAMPOLINE_BUFFERSIZE]; 
	DWORD cbRead;
	CHAR chReply[TRAMPOLINE_BUFFERSIZE];
	DWORD cbToWrite; 
	DWORD dwState; 
	BOOL fPendingIO; 
} PIPEINST, *LPPIPEINST; 

static PIPEINST Pipe[TRAMPOLINE_INSTANCES]; 
static HANDLE hEvents[TRAMPOLINE_INSTANCES]; 

static LPTSTR SERVICESNAPSHOT_FILESYSTEMPATH_SERVICEEXE = TEXT("C:\\Ludus\\Release\\ServiceSnapShot.exe");
static LPTSTR SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL = TEXT("C:\\Ludus\\Release\\Trampoline.Reporter.dll");
static LPTSTR SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL = TEXT("C:\\Ludus\\Release\\Trampoline.dll");
static LPTSTR SERVICESNAPSHOT_TRAMPOLINE_PATH = TEXT("\\\\.\\Pipe\\Ludus"); 
