using System;
using System.Collections;
using System.Text;

namespace Shared.Delegate
{
    [Serializable]
    public class Messages : MarshalByRefObject
    {
        [Serializable]
        public class Debugger
        {
            public Boolean debug;

            public Debugger(Boolean Debug)
            {
                debug = Debug;
            }
        }

        [Serializable]
        public class Process
        {
            public String action;
            public UInt32 pid;
            public String name;

            public Process()
            {
                action = String.Empty;
                pid = UInt32.MinValue;
                name = String.Empty;
            }

            public Process(UInt32 Pid, String Name)
            {
                action = String.Empty;
                pid = Pid;
                name = Name;
            }
        }

        [Serializable]
        public class Client
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public Boolean allowmonitor;
            public Boolean allowplay;

            public Client(String Action, UInt32 Pid, IntPtr Hwnd)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                allowmonitor = false;
                allowplay = false;
            }
        }

        [Serializable]
        public class Element
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public String key;
            public String id;
            public IntPtr chwnd;
            public String xy;
            public String value;

            public Element(String Action, UInt32 Pid, IntPtr Hwnd, String Key)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                key = Key;
                id = String.Empty;
                chwnd = IntPtr.Zero;
                xy = String.Empty;
                value = String.Empty;
            }
        }
    }
}
