using System;
using System.Collections;
using System.Text;

namespace Shared.Logic
{
    [Serializable]
    public class Messages : MarshalByRefObject
    {
        [Serializable]
        public class Debugger
        {
            public Boolean debug;

            public Debugger(Boolean Debug)
            {
                debug = Debug;
            }
        }

        [Serializable]
        public class Process
        {
            public String action;
            public UInt32 pid;
            public String name;

            public Process(String Action, UInt32 Pid)
            {
                action = Action;
                pid = Pid;
                name = String.Empty;
            }
        }

        [Serializable]
        public class Client
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public String caption;
            public Hashtable layout;
            public String profile;
            public Boolean allowmonitor;
            public Boolean allowplay;

            public Client(String Action, UInt32 Pid, IntPtr Hwnd)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                caption = String.Empty;
                layout = new Hashtable();
                profile = String.Empty;
                allowmonitor = false;
                allowplay = false;
            }
        }

        [Serializable]
        public class Element
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public String key;
            public String id;
            public IntPtr chwnd;
            public String value;
            public Double amount;

            public Element(String Action, UInt32 Pid, IntPtr Hwnd, String Key)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                key = Key;
                id = String.Empty;
                chwnd = IntPtr.Zero;
                value = String.Empty;
                amount = 0;
            }
        }
    }
}
