using System;
using System.Collections;
using System.Text;

namespace Shared.Logic.Poker
{
    [Serializable]
    public class Messages : MarshalByRefObject
    {
        [Serializable]
        public class State
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public ArrayList playercards;
            public ArrayList tablebuttons;
            public ArrayList tablecards;
            public Int32 playersactive;
            public Int32 playersseated;
            public Double playerhighcard;
            public Double playertwoofakind;
            public Double playertwopair;
            public Double playerthreeofakind;
            public Double playerstraight;
            public Double playerflush;
            public Double playerfullhouse;
            public Double playerfourofakind;
            public Double playerstraightflush;
            public Double playerchances;
            public Double enemyhighcard;
            public Double enemytwoofakind;
            public Double enemytwopair;
            public Double enemythreeofakind;
            public Double enemystraight;
            public Double enemyflush;
            public Double enemyfullhouse;
            public Double enemyfourofakind;
            public Double enemystraightflush;
            public Double enemychances;
            public ArrayList debug;

            public State(String Action, UInt32 Pid, IntPtr Hwnd)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                playercards = new ArrayList();
                tablebuttons = new ArrayList();
                tablecards = new ArrayList();
                playersactive = 0;
                playersseated = 0;
                playerhighcard = 0.0;
                playertwoofakind = 0.0;
                playertwopair = 0.0;
                playerthreeofakind = 0.0;
                playerstraight = 0.0;
                playerflush = 0.0;
                playerfullhouse = 0.0;
                playerfourofakind = 0.0;
                playerstraightflush = 0.0;
                playerchances = 0.0;
                enemyhighcard = 0.0;
                enemytwoofakind = 0.0;
                enemytwopair = 0.0;
                enemythreeofakind = 0.0;
                enemystraight = 0.0;
                enemyflush = 0.0;
                enemyfullhouse = 0.0;
                enemyfourofakind = 0.0;
                enemystraightflush = 0.0;
                enemychances = 0.0;
                debug = new ArrayList();
            }
        }

        [Serializable]
        public class Profile
        {
            public UInt32 pid;
            public IntPtr hwnd;
            public String description;
            public PreFlop preflop;
            public PostFlop postflop;

            public Profile(String Description)
            {
                pid = UInt32.MinValue;
                hwnd = IntPtr.Zero;
                description = Description;
                preflop = new PreFlop();
                postflop = new PostFlop();
            }
            [Serializable]
            public class PreFlop
            {
                public Boolean enable;
                public AllIn allin;
                public Raise raise;
                public Bet bet;
                public Call call;
                public Check check;
                public Fold fold;
                public PostSB postsb;
                public PostBB postbb;

                public PreFlop()
                {
                    enable = false;
                    allin = new AllIn();
                    raise = new Raise();
                    bet = new Bet();
                    call = new Call();
                    check = new Check();
                    fold = new Fold();
                    postsb = new PostSB();
                    postbb = new PostBB();
                }
            }
            [Serializable]
            public class PostFlop
            {
                public Boolean enable;
                public AllIn allin;
                public Raise raise;
                public Bet bet;
                public Call call;
                public Check check;
                public Fold fold;

                public PostFlop()
                {
                    enable = false;
                    allin = new AllIn();
                    raise = new Raise();
                    bet = new Bet();
                    call = new Call();
                    check = new Check();
                    fold = new Fold();
                }
            }
            [Serializable]
            public class AllIn
            {
                public Boolean enable;
                public float chance;
                public float amount;

                public AllIn()
                {
                    enable = false;
                    chance = 0;
                    amount = 0;
                }
            }
            [Serializable]
            public class Raise
            {
                public Boolean enable;
                public float chance;
                public float amount;

                public Raise()
                {
                    enable = false;
                    chance = 0;
                    amount = 0;
                }
            }
            [Serializable]
            public class Bet
            {
                public Boolean enable;
                public float chance;
                public float amount;

                public Bet()
                {
                    enable = false;
                    chance = 0;
                    amount = 0;
                }
            }
            [Serializable]
            public class Call
            {
                public Boolean enable;
                public float chance;
                public float amount;

                public Call()
                {
                    enable = false;
                    chance = 0;
                    amount = 0;
                }
            }
            [Serializable]
            public class Check
            {
                public Boolean enable;

                public Check()
                {
                    enable = false;
                }
            }
            [Serializable]
            public class Fold
            {
                public Boolean enable;

                public Fold()
                {
                    enable = false;
                }
            }
            [Serializable]
            public class PostSB
            {
                public Boolean enable;
                public float amount;

                public PostSB()
                {
                    enable = false;
                    amount = 0;
                }
            }
            [Serializable]
            public class PostBB
            {
                public Boolean enable;
                public float amount;

                public PostBB()
                {
                    enable = false;
                    amount = 0;
                }
            }
        }
    }
}
