using System;
using System.Collections;
using System.Diagnostics;
using System.Management;
using System.Text;

namespace Shared.WMI
{
    public class Services
    {
        public static Boolean EnableAllowInteractWithDesktop(String service)
        {
            // http://www.codeproject.com/KB/system/ScreenMonitor.aspx?display=Print
            try
            {
                ManagementClass mc = new ManagementClass("Win32_Service");
                ManagementObjectCollection moc = mc.GetInstances();

                foreach (ManagementObject mo in moc)
                {
                    // Make sure we find the correct service to adjust the setting on.
                    if ((bool)mo["Caption"].Equals(service))
                    {
                        ManagementBaseObject desktopInteract = mo.GetMethodParameters("Change");

                        desktopInteract["DesktopInteract"] = true;
                        mo.InvokeMethod("Change", desktopInteract, null);

                        // We found the service, set it, no need to continue iteration.
                        break;
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", service);
                StringBuilder evtEntry = new StringBuilder("Shared::WMI::Services::EnableAllowInteractWithDesktop()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);

                return false;
            }
        }
    }
}
