using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.XPath;

namespace Shared.XML.Delegate
{
    public class Reader
    {
        public static Objects.Service.Log LogConfig()
        {
            Objects.Service.Log l = new Objects.Service.Log();

            try
            {
                l.collectiondaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/Delegate/Log/CollectionDaemonize"));
                l.messengerdaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/Delegate/Log/MessengerDaemonize"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Delegate::Reader::Log()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return l;
        }
        public static Objects.Service.Collection CollectionConfig()
        {
            Objects.Service.Collection c = new Objects.Service.Collection();

            try
            {
                c.daemonizepollinginterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/Delegate/Collection/DaemonizePollingInterval"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Delegate::Reader::CollectionConfig())");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return c;
        }
        public static Objects.Service.Messenger MessengerConfig()
        {
            Objects.Service.Messenger m = new Objects.Service.Messenger();

            try
            {
                m.ip = ParseInnerXML(Globals.configs, "/Ludus/Service/Probability/Messenger/IP");
                m.port = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/Service/Probability/Messenger/Port"));
                m.protocol = ParseInnerXML(Globals.configs, "/Ludus/Service/SnapShot/Probability/Protocol");
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Delegate::Reader::MessengerConfig()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return m;
        }

        private static String ParseInnerXML(String file, String path)
        {
            String rslt = String.Empty;

            try
            {
                XmlNode node;
                XmlDocument xmldoc = new XmlDocument();
                xmldoc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);

                /* Compile a standard XPath expression. */
                node = xmldoc.SelectSingleNode(path);

                rslt = node.InnerXml;
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Delegate::Reader::ParseInnerXML()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return rslt;
        }
        private static ArrayList ParseSiblingValues(String file, String path)
        {
            ArrayList list = new ArrayList();

            try
            {
                /* Compile a standard XPath expression. */
                XPathDocument xpathdoc = new XPathDocument(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);
                XPathNavigator nav = xpathdoc.CreateNavigator();
                XPathExpression expr = nav.Compile(path);
                XPathNodeIterator iterator = nav.Select(expr);

                while (iterator.MoveNext())
                {
                    XPathNavigator navDomain = iterator.Current.Clone();
                    list.Add(navDomain.Value);
                }
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Delegate::Reader::ParseSiblingValues()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return list;
        }
    }
}
