/*
 * Chris Ragland
 * November 17th 2008
 * 
 * Background.cs
 * 
 * Background is what is drawn behind each level as it occurs.
 * The color is a clue to the player as to what gravity is currently
 * active and altering the bullet.
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class Background:DrawnObject
	{
		private Color color = Color.White;

		public Background()
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"), new Rectangle(40, 80, 1200, 600))
		{
		}

		//Method that renders the background depending on the current gravity.
		public void Render(int gravity)
		{
			if(gravity == 1)
				color = Color.LimeGreen;
			else if(gravity == 2)
				color = Color.OrangeRed;
			else if(gravity == 3)
				color = Color.Goldenrod;
			else if(gravity == 4)
				color = Color.RoyalBlue;
			else
				color = Color.White;
			SeniorProject.SpriteBatch.Draw(texture, rectangle, color);
		}
	}
}
