/*
 * Chris Ragland
 * November 14th 2008
 * 
 * BounceWall.cs
 * 
 * Creates a Bounce Wall, that causes a bullet to bounce when it hits.
 * Needs a direction to cause the bullet to bounce in. Not the best
 * way to handle this, but I didn't have time to refactor :(
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class BounceWall:DrawnObject
	{
		private int bounceDirection = -1;

		public BounceWall(Vector2 position, Rectangle rectangle, int bounceDirection)
			: base(position, SeniorProject.ContentManager.Load<Texture2D>(@"Content\bounce"), rectangle)
		{
			this.bounceDirection = bounceDirection;
		}

		public override void Render()
		{
			SeniorProject.SpriteBatch.Draw(texture, rectangle, rectangle, Color.White);
		}

		public int BounceDirection
		{
			get { return bounceDirection; }
		}
	}
}