/*
 * Chris Ragland
 * November 14th 2008
 * 
 * Bullet.cs
 * 
 * Creates a bullet. Passed in the players location as position, a vector for the direction
 * the velocity, and the level's gravity coefficient. Moves depending on the gravity.
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class Bullet:DrawnObject
	{
		private Vector2 direction;
		private float time;
		private float gravityCoefficient = -1;
		private int lastGravity = -1;
		private bool[] bouncing;

		public Bullet(Vector2 position, Vector2 direction, float velocity, float gravityCoefficient)
			: base(position, SeniorProject.ContentManager.Load<Texture2D>(@"Content\bullet"), new Rectangle((int)position.X, (int)position.Y, 5, 5))
		{
			this.direction = direction;
			this.direction.Normalize();
			this.direction.X *= velocity;
			this.direction.Y *= velocity;
			this.gravityCoefficient = gravityCoefficient;
			bouncing = new bool[] { false, false };
		}

		//Updates the bullet's movement
		public void Update(int gravity)
		{
			if(lastGravity != gravity)
				time = 0.0f;
			time += .02f;

			switch(gravity)
			{
				case 2:
					direction.X += (.5f * gravityCoefficient * ((time * time) / 60));
					break;
				case 1:
					direction.Y += (.5f * gravityCoefficient * ((time * time) / 60));
					break;
				case 4:
					direction.X -= (.5f * gravityCoefficient * ((time * time) / 60));
					break;
				case 3:
					direction.Y -= (.5f * gravityCoefficient * ((time * time) / 60));
					break;
				default:
					break;
			}

			position.X += direction.X;
			position.Y += direction.Y;
			rectangle.X = (int)position.X;
			rectangle.Y = (int)position.Y;

			lastGravity = gravity;
		}

		public void bounce(int bounceDir)
		{
			if(bounceDir == 2 || bounceDir == 4)
			{
				direction.X = -direction.X;
				bouncing[0] = true;
			}
			else if(bounceDir == 1 || bounceDir == 3)
			{
				direction.Y = -direction.Y;
				bouncing[1] = true;
			}
		}

		#region BouncingInfo
		public bool bouncingX()
		{
			return bouncing[0];
		}

		public bool bouncingY()
		{
			return bouncing[1];
		}

		public void setNotBouncing()
		{
			setNotBouncingX();
			setNotBouncingY();
		}

		public void setNotBouncingX()
		{
			bouncing[0] = false;
		}

		public void setNotBouncingY()
		{
			bouncing[1] = false;
		}
		#endregion
	}
}
