/*
 * Chris Ragland
 * November 16th 2008
 * 
 * ControlUnit.cs
 *
 * Controls the keyboard.
 * 
 */

using System;
using Microsoft.Xna.Framework;

namespace SeniorProject
{
	abstract public class ControlUnit
	{
		private double angle;
		private double degree;
		private bool shoot;
		private int gravity;
		private bool anyPressed;
		private bool escPressed;
		private bool leftPressed;
		private bool rightPressed;
		private bool upPressed;
		private bool downPressed;
		private bool enterPressed;

		#region Properties
		public double Angle
		{
			get { return angle; }
		}

		public bool Shoot
		{
			get { return shoot; }
			set { shoot = value; }
		}

		public int Gravity
		{
			get { return gravity; }
			set { gravity = value; }
		}

		public Vector2 ShootVector
		{
			get { return new Vector2((float)Math.Cos(angle), (float)Math.Sin(angle)); }
		}

		public bool AnyPressed
		{
			get { return anyPressed; }
			set { anyPressed = value; }
		}

		public bool EscPressed
		{
			get { return escPressed; }
			set { escPressed = value; }
		}

		public bool LeftPressed
		{
			get { return leftPressed; }
			set { leftPressed = value; }
		}

		public bool RightPressed
		{
			get { return rightPressed; }
			set { rightPressed = value; }
		}
		public bool UpPressed
		{
			get { return upPressed; }
			set { upPressed = value; }
		}

		public bool DownPressed
		{
			get { return downPressed; }
			set { downPressed = value; }
		}

		public bool EnterPressed
		{
			get { return enterPressed; }
			set { enterPressed = value; }
		}

		#endregion

		public ControlUnit(int gravity)
		{
			angle = 0;
			degree = 0;
			this.gravity = gravity;
		}

		public virtual void Update()
		{
		}

		protected void alterAngle(double value)
		{
			degree += value;
			angle = (degree * (Math.PI / (double)180));
		}
	}
}