/*
 * Chris Ragland
 * September 18th 2008
 * 
 * GameScreen.cs
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;

namespace SeniorProject
{
	public class GameScreen:Screen
	{
		PuzzleGame puzzle;
		protected long score;

		public GameScreen(long highScore)
			: base()
		{
			score = 0;
			puzzle = new PuzzleGame(highScore);
		}

		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			puzzle.Update(elapsed);
			if(!puzzle.GameOver)
			{
				return GameState.None;
			}
			else
			{
				score = puzzle.Score;
				return GameState.GameOver;
			}
		}

		public override void Render()
		{
			puzzle.Render();
		}

		public long Score
		{
			get { return score; }
		}
	}
}
