/*
 * Chris Ragland
 * September 18th 2008
 * 
 * IntroScreen.cs
 * 
 * Explains the basis of the game and the controls.
 * There is a timer that will automatically move the player to the first
 * level after a set period of time has passed.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class IntroScreen:Screen
	{
		private double timeout = 5;
		private double endTime = -1;

		private string story = "You have been selected to join the Earth Alliance\nDefense Force, but before we can send you out\ninto space we need to test your skills as a gunner... \n\n\nThis is a simulation, but all the tools our latest ships are\nequipped with are there, including our newest weapon the LAGAD\ncapable of projecting and altering the gravity field around you.\n\nYou will be presented with various challenges. Destroy all \nthe targets and you might just make it...";

		public IntroScreen()
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"))
		{
			GC.Collect();
		}

		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			if(endTime < 0)
			{
				endTime = time.TotalSeconds + timeout;
			}

			if(timeout != 0 && time.TotalSeconds > endTime)
			{
				return GameState.PlayGame;
			}
			else
			{
				return GameState.None;
			}
		}

		public override void Render()
		{
			SeniorProject.SpriteBatch.Begin();
			SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, story, new Vector2(240, 100), Color.BlanchedAlmond);
			SeniorProject.SpriteBatch.End();
		}
	}
}