/*
 * Chris Ragland
 * September 18th 2008
 * 
 * KeyboardController.cs
 * 
 */

using Microsoft.Xna.Framework.Input;

namespace SeniorProject
{
	public class KeyboardController:ControlUnit
	{
		private KeyboardState oldState;
		private KeyboardState curState;
		private int currentGravity;

		public KeyboardController(int gravity)
			: base(gravity)
		{
			oldState = Keyboard.GetState();
			curState = oldState;
			currentGravity = gravity;
		}

		public override void Update()
		{
			oldState = curState;
			curState = Keyboard.GetState();
			base.alterAngle(checkAngleKeys());
			Shoot = shoot();
			AnyPressed = anyPressed();

			EscPressed = keyPressed(Keys.Escape);
			LeftPressed = keyPressed(Keys.Left);
			RightPressed = keyPressed(Keys.Right);
			UpPressed = keyPressed(Keys.Up);
			DownPressed = keyPressed(Keys.Down);
			EnterPressed = keyPressed(Keys.Enter);

			currentGravity = checkGravityKeys();

			if(currentGravity > 0)
				Gravity = currentGravity;

		}

		private double checkAngleKeys()
		{
			if(curState.IsKeyDown(Keys.Left))
				return -0.75;
			else if(curState.IsKeyDown(Keys.Right))
				return 0.75;
			else
				return 0;
		}

		private bool shoot()
		{
			if(curState.IsKeyDown(Keys.Space) && oldState.IsKeyUp(Keys.Space))
				return true;
			else
				return false;
		}

		private bool anyPressed()
		{
			if(curState.GetPressedKeys().Length > 0 && oldState.GetPressedKeys().Length == 0)
				return true;
			else
				return false;
		}

		//Edge detects if a key is pressed. Prevents pressing
		//and holding down
		private bool keyPressed(Keys key)
		{
			if(curState.IsKeyDown(key) && oldState.IsKeyUp(key))
				return true;
			else
				return false;
		}

		private int checkGravityKeys()
		{
			if(curState.IsKeyDown(Keys.A))
				return 4;
			else if(curState.IsKeyDown(Keys.S))
				return 1;
			else if(curState.IsKeyDown(Keys.D))
				return 2;
			else if(curState.IsKeyDown(Keys.W))
				return 3;
			else
				return 0;
		}
	}
}
