/*
 * Chris Ragland
 * November 14th 2008
 * 
 * ScoreBar.cs
 * Renders the score bar, which contains the current score, time left in the level
 * and the current high score the player is shooting for.
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class ScoreBar:DrawnObject
	{
		private string scoreString;
		private string timeString;
		private string highString;
		private int lastTime = -1;

		public ScoreBar(long score, int time, long highScore)
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\bullet"), new Rectangle(0, 0, 1280, 40))
		{
			scoreString = new string('0', 10 - score.ToString().Length) + score;
			timeString = new string('0', 5 - time.ToString().Length) + time;
			highString = new string('0', 10 - highScore.ToString().Length) + highScore;
			lastTime = time;
		}

		/*
		 * Renders the score bar. A score bar contains the current players
		 * score, the time left in the level, and the current high score.
		 * Score will only update after each level, same goes for High Score.
		 * 
		 */

		public void Render(int time)
		{
			if(lastTime != time)
			{
				timeString = new string('0', 5 - time.ToString().Length) + time;
				lastTime = time;
			}
			SeniorProject.SpriteBatch.Draw(texture, rectangle, Color.Black);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, " Current Score: " + scoreString + "              Time Left: " + timeString + "              High Score: " + highString, new Vector2(5, 5), Color.AliceBlue);
		}
	}
}