/*
 * Chris Ragland
 * September 18th 2008
 * 
 * TitleScreen.cs
 * 
 * Presents the player with an image of the title screen
 * some nice background music and waits for them to respond.
 * 
 * Can progress to the gameplay introduction screen or the
 * high score screen from here. They may also quit the game.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class TitleScreen:Screen
	{
		private double timeout = 5;
		private double endTime = -1;
		private string gameTitle = "";

		public TitleScreen(string gameTitle)
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"))
		{
			this.gameTitle = gameTitle;
		}

		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			if(endTime < 0)
			{
				endTime = time.TotalSeconds + timeout;
			}

			if(timeout != 0 && time.TotalSeconds > endTime)
			{
				return GameState.HighScore;				// Wait long enough, go to high score screen
			}
			else if(SeniorProject.Controller.AnyPressed)
			{
				return GameState.IntroScreen;			// Any button pressed, go to intro screen
			}
			else
			{
				return GameState.None;					// Neither of the above? Don't change
			}
		}

		public override void Render()
		{
			Vector2 position = new Vector2(340, 200);

			SeniorProject.SpriteBatch.Begin();
			SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
			for(int i = 0; i < 15; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, gameTitle, position, Color.Black);		// Faux 3-d Title
				position.X++;
				position.Y++;
			}
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, gameTitle, position, Color.BlanchedAlmond);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, "Press Any Button", new Vector2(980, 660), Color.GreenYellow);
			SeniorProject.SpriteBatch.End();
		}
	}
}