import com.ridgesoft.intellibrain.IntelliBrain;

public class Robo implements Runnable
{   private RoboSerial   serial1;
    private RoboSerial   serial2;
    private RoboDisplay  display;
    private RoboSpeaker  speaker;
    private RoboLED      led;
	private RoboServo    servo;
    private RoboSonar    sonar;
    private RoboInfrared light;
    private RoboLine     line;
    //private RoboCamera cmu1;
    
 	public static void main(String args[])
	{   //LAPTOP COM CONNECTION THREAD
        RoboSerial serial1 = new RoboSerial(115200, 25, false, true);
        Thread threadSerial1 = new Thread (serial1);
        threadSerial1.setPriority(Thread.NORM_PRIORITY);
            
        //CAMERA COM CONNECTION THREAD
        RoboSerial serial2 = new RoboSerial(115200, 25, false, false);
        Thread threadSerial2 = new Thread (serial2);
        threadSerial2.setPriority(Thread.NORM_PRIORITY);

        //DISPLAY THREAD
        RoboDisplay display = new RoboDisplay(serial1);
        Thread threadDisplay = new Thread (display);
        threadDisplay.setPriority(Thread.NORM_PRIORITY);

        //SPEAKER THREAD
        RoboSpeaker speaker = new RoboSpeaker();
        Thread threadSpeaker = new Thread (speaker);
        threadSpeaker.setPriority(Thread.NORM_PRIORITY);

        //LED THREAD
        RoboLED led = new RoboLED();
        Thread threadLED = new Thread (led);
        threadLED.setPriority(Thread.NORM_PRIORITY);

        //MOTORS
        RoboServo servo = new RoboServo();
        Thread threadServo = new Thread (servo);
        threadServo.setPriority(Thread.NORM_PRIORITY);

        //INFRARED RANGE SENSOR
        RoboInfrared light = new RoboInfrared(serial1, display);
        Thread threadLight = new Thread (light);
        threadLight.setPriority(Thread.NORM_PRIORITY);

        //LINE SENSOR
        RoboLine line = new RoboLine (serial1, display);
        Thread threadLine = new Thread (line);
        threadLine.setPriority(Thread.NORM_PRIORITY);

        //SONAR SENSOR
        RoboSonar sonar = new RoboSonar(serial1, display);
        Thread threadSonar = new Thread (sonar);
        threadSonar.setPriority(Thread.NORM_PRIORITY);
        //this.threadSonar.start();

        //CAMERA SENSOR, LAST THREE ARE RGB, WHITE BALANCE, AUTOEXPOSURE
        //RoboCamera cmu1 = new RoboCamera(serial1, serial2, display, true, true, true);
        //Thread threadCMU1 = new Thread(cmu1);
        //threadCMU1.setPriority(Thread.NORM_PRIORITY);

        //EXECUTIONER
        Robo robo = new Robo (serial1, serial2, display, speaker, led, servo, light, line, sonar/*, cmu1*/);
        Thread threadRobo = new Thread(robo);
        threadRobo.setPriority(Thread.NORM_PRIORITY);


        threadSerial1.start();
        //threadSerial2.start();
        threadDisplay.start();
        threadSpeaker.start();
        threadLED.start();
        threadServo.start();
        threadLight.start();
        threadLine.start();
        threadSonar.start();
        //threadCMU1.start();
        threadRobo.start();
    }

	public Robo (RoboSerial serial1, RoboSerial serial2, RoboDisplay display,
                 RoboSpeaker speaker, RoboLED led, RoboServo servo,
                 RoboInfrared light, RoboLine line, RoboSonar sonar/*, RoboCamera cmu1*/)
	{	this.serial1 = serial1;
        this.serial2 = serial2;
        this.display = display;
        this.speaker = speaker;
        this.led = led;
        this.servo = servo;
        this.light = light;
        this.line = line;
        this.sonar = sonar;
        //this.cmu1 = cmu1;
	}

    private int getTimeValue (byte u, byte l)
    {   return ((int)u * 256) + (int)l * 1;
    }

    //******************* DISPLAY *******************//
    private void executeDisplay (byte[] b)
    {   if ((char)b[2] == 'i' && (char)b[4] == 't' && (char)b[7] == 'd')
        {   switch ((char)b[1])
            {   case 'r':
                    this.serial1.writeOut(new String(this.getCommand('d', 'w', (char)b[3], '0', '0', this.display.readTextLine(b[3]-48))));
                    break;
                case 'w':
                    this.display.writeTextLine(b[3]-48, new String(b, 8, b.length-7));
                    break;
                default :
                    break;
            }
        }
    }

    //******************* SOUND *******************//
    public void executeSpeaker (byte[] b)
    {   if ((char)b[2] == 'i' && (char)b[4] == 't' && (char)b[7] == 'd')
        {   switch ((char)b[1])
            {   case 'b':
                    this.speaker.setTime(this.getTimeValue(b[5], b[6]));
                    this.speaker.setFlag('b');
                    break;
                case 'c':
                    this.speaker.setTime(this.getTimeValue(b[5], b[6]));
                    this.speaker.setFlag('c');
                    break;
                case 'p':   //PLAY
                    //this.speaker.setFreq(this.getTimeValue(b[5], b[6]));
                    //this.speaker.setFreq(b[8]);
                    //this.speaker.setTime(this.getTimeValue(b[5], b[6]));
                    //this.speaker.setTime(b[6]);
                    this.speaker.setFlag('p');
                    break;
                default :
                    this.speaker.setFlag('s');
                    break;
    }   }   }

    public void executeLED (byte[] b)
    {   if ((char)b[2] == 'i' && (char)b[4] == 't' && (char)b[7] == 'd')
        {   boolean[] state = new boolean[8];
            //USER LED 1, USER LED 2, ....
            if (b[9]  == 1)  state[1] = true; else state[1] = false;
            if (b[10] == 1)  state[2] = true; else state[2] = false;
            if (b[11] == 1)  state[3] = true; else state[3] = false;
            if (b[12] == 1)  state[4] = true; else state[4] = false;
            if (b[13] == 1)  state[5] = true; else state[5] = false;
            if (b[14] == 1)  state[6] = true; else state[6] = false;
            if (b[15] == 1)  state[7] = true; else state[7] = false;

            this.led.setState(state);
        }
    }

    public void executeServo (byte[] b)
    {   if ((char)b[2] == 'i' && (char)b[4] == 't' && (char)b[7] == 'd')
        {   switch ((char)b[1])
            {   case 'f':
                    this.servo.setFlag(0);
                    break;
                case 'b':
                    this.servo.setFlag(1);
                    break;
                case 'l':
                    this.servo.setFlag(2);
                    break;
                case 'r':
                    this.servo.setFlag(3);
                    break;
                case 's':
                    this.servo.setFlag(4);
                    break;
                default :
                    break;
    }   }   }

    //******************* PROXIMITY SENSOR *******************//
    public void executeRange (byte[] b)
    {   if ((char)b[2] == 'i' && (char)b[4] == 't' && (char)b[7] == 'd')
        {   switch ((char)b[1])
            {   case 'i':   //INFRARED
                            this.light.toggle();
                        break;
                case 'l':   //LINE
                            this.line.toggle();
                        break;
                case 's':   //SONAR
                            this.sonar.toggle();
                        break;
                default :
                        break;
            }
        }
    }



    private byte[] getCommand (char c, char m, char i, char tu, char tl, String d)
    {   byte[] command = new byte[this.serial1.getCommandLength()];

        //LOAD COMMAND CONSTANTS
        command[0] = (byte) c;
        command[1] = (byte) m;
        command[2] = 'i';
        command[3] = (byte) i;
        command[4] = 't';
        command[5] = (byte) tu;
        command[6] = (byte) tl;
        command[7] = 'd';

        //LOAD DATA, LONGER STRING WILL JUST DROP
        for (int n=8; n<command.length-1; ++n)
        {   if (n-8 > (d.length()-1))
                command[n] = 0;
            else
                command[n] = d.getBytes()[n-8];
        }

        //TERMINATE WITH CR
        command[command.length-1] = '\r';

        return command;
    }

    public void run()
    {   try
        {   this.display.writeTextLine(0, "MAIN");
			while(true)
            {   if (this.serial1.isPoll() == true)
				{   String cmdTemp = this.serial1.readIn();

                    if(cmdTemp != null)
                    {	byte[] cmd = cmdTemp.getBytes();
                        switch ((char)cmd[0])
                        {   case 'd': this.display.writeTextLine(1, "DISPLAY");
                                      this.executeDisplay(cmd);
                                    break;
                            case 's': this.display.writeTextLine(1, "SPEAKER");
                                      this.executeSpeaker(cmd);
                                    break;
                            case 'l': this.display.writeTextLine(1, "LED");
                                      this.executeLED(cmd);
                                    break;
                            case 'm': this.display.writeTextLine(1, "SERVO");
                                      this.executeServo(cmd);
                                    break;
                            case 'r': this.display.writeTextLine(1, "RANGE");
                                      this.executeRange(cmd);
                                    break;
                            default : this.display.writeTextLine(0, "Comm Error");
                                      this.display.writeTextLine(1, new String(cmd));
                                    break;
                        }
                    }
					Thread.yield();
                }
            }
        }
        catch (Throwable t) { t.printStackTrace(); }
    }
}