import com.ridgesoft.intellibrain.IntelliBrain;
import com.ridgesoft.io.Display;

/* THIS IS THE DISPLAY CLASS. IT KEEPS DISPLAYING WHATEVER IS IN THE
 * TEXT ARRAY OF STRINGS. CHANGE ARRAY VALUES TO CHANGE DISPLAYED VALUES.
 * DO NOT ACCESS PRINT METHODS DIRECTLY.
*/

public class RoboDisplay implements Runnable
{   private Display    display;
    private RoboSerial serial;
    private int        rows;
    private int        cols;
    private String[]   text;

    public RoboDisplay (RoboSerial s)
    {   this.display = IntelliBrain.getLcdDisplay();
        this.serial = s;
        this.rows = 2;
        this.cols = 16;
        this.text = new String[this.rows];
        for (int i=0; i<this.rows; ++i)
            this.text[i] = null;
    }

    public void writeTextLine(int r, String t)
    {   if (r < this.text.length)
            this.text[r] = getLineString(t);
    }   

    public String readTextLine(int r)
    {   if (r < this.text.length)
            return this.text[r];

        return null;
    }

    public void run()
    {   try
        {   while(true)
            {   for (int r=0; r<this.rows; ++r)
                {   if (this.readTextLine(r) != null)
                    {   this.display.print (r, this.readTextLine(r));
                        this.serial.writeOut ("dwi"+r+"t00d"+this.text[r]+'\r');
                        //this.writeTextLine(r, null);
                }   }
                Thread.sleep(50);
				//Thread.yield();
            }
        }catch (Throwable t) {t.printStackTrace();}
    }

    //TRIM THE STRING TO FIT ROW LENGTH
    private String getLineString (String t)
    {   if (t.length() < this.cols)
			return t;
		else
		{	byte[] tb = t.getBytes();		
        	return  new String(tb, 0, this.cols);
		}
    }

    public int getCols()
    {   return this.cols;
    }

    public int getRows()
    {   return rows;
    }

    public String[] getText()
    {   return text;
    }
}