import com.ridgesoft.intellibrain.*;
import com.ridgesoft.robotics.Servo;

public class RoboServo implements Runnable
{   private Servo     servoRight;
	private Servo	  servoLeft;
    private boolean[] flag;

    public RoboServo ()
    {   this.servoLeft  = IntelliBrain.getServo(1);
        this.servoRight = IntelliBrain.getServo(2);

        this.flag = new boolean[5];
        for (int i=0; i<this.flag.length; ++i)
            this.flag[i] = false;
    }

    public void moveForward ()
    {	this.servoLeft.setPosition(100);
        this.servoRight.setPosition(0);
    }

    public void moveBackward ()
    {   this.servoLeft.setPosition(0);
        this.servoRight.setPosition(100);
    }

    public void turnLeft ()
    {	this.servoLeft.setPosition(0);
        this.servoRight.setPosition(0);
    }

    public void turnRight ()
    {	this.servoLeft.setPosition(100);
        this.servoRight.setPosition(100);
    }

    public void servoOff ()
    {   this.servoLeft.off();
        this.servoRight.off();
        this.setFlag(-1);
    }

    //f,b,l,r,s
    public void setFlag (int s)
    {   for (int i=0; i<this.flag.length; ++i)
        {   this.flag[i] = false;
            if (i == s)
                this.flag[i] = true;
    }   }

    public void run()
    {   while(true)
        {   try
            {   for(int i=0; i<this.flag.length; ++i)
                {   if(this.flag[i] == true)
                    {    if (i==0)      this.moveForward();
                         else if (i==1) this.moveBackward();
                         else if (i==2) this.turnLeft();
                         else if (i==3) this.turnRight();
                         else if (i==4) this.servoOff();
                    }
                }
            }   catch (Throwable t) { t.printStackTrace(); }
            Thread.yield();
        }
    }
}