import com.ridgesoft.intellibrain.*;
import com.ridgesoft.io.*;
import com.ridgesoft.robotics.AnalogInput;

public class RoboLine implements Runnable
{   private AnalogInput[]  line;
    private int[]          sample;
    private boolean        on;
    private RoboSerial     serial;
    private RoboDisplay    display;

    public RoboLine (RoboSerial s, RoboDisplay d)
    {   this.line = new AnalogInput[2];
		this.line[0] = IntelliBrain.getAnalogInput(6);
        this.line[1] = IntelliBrain.getAnalogInput(7);
        this.sample = new int[2];
		this.sample[0] = this.sample[1] = 0;
        this.on = false;
        this.serial = s;
        this.display = d;
    }

    private void sample ()
    {   this.sample(0);
        this.sample(1);
    }
	
    public int sample (int i)
    {   this.sample[i] = this.line[i].sample();
		return this.sample[i];
    }

    public void display ()
    {   this.display.writeTextLine (0, "LINE LEFT: "+this.sample[0]);
        this.display.writeTextLine (1, "LINE RIGHT: "+this.sample[1]);
    }

    private void send ()
    {   this.serial.writeOut (""+'r'+'l'+'i'+'0'+'t'+'0'+'0'+'d'+this.sample[0]+'\r');
		this.serial.writeOut (""+'r'+'l'+'i'+'1'+'t'+'0'+'0'+'d'+this.sample[1]+'\r');
    }

    public void toggle ()
    {   this.on = !this.on;
    }

    public boolean isOn ()
    {   return this.on;
    }

    public void run()
    {   while(true)
        {   try
            {   if (this.isOn())
                {    this.sample();
					 this.display();
                     this.send();
                }
            }   catch (Throwable t) { t.printStackTrace(); }
            Thread.yield();
        }
    }
}