public class SpeakerTones
{   private String[][] baseNotes;

    public SpeakerTones()
    {   int c = 0;
        baseNotes = new String[13][2];

        baseNotes[c][0] = "empty";
        baseNotes[c++][1] = "0";

        baseNotes[c][0] = "C";
        baseNotes[c++][1] = "262";

        baseNotes[c][0] = "C#";
        baseNotes[c++][1] = "277";

        baseNotes[c][0] = "D";
        baseNotes[c++][1] = "294";

        baseNotes[c][0] = "D#";
        baseNotes[c++][1] = "311";

        baseNotes[c][0] = "E";
        baseNotes[c++][1] = "330";

        baseNotes[c][0] = "F";
        baseNotes[c++][1] = "349";

        baseNotes[c][0] = "F#";
        baseNotes[c++][1] = "370";

        baseNotes[c][0] = "G";
        baseNotes[c++][1] = "392";

        baseNotes[c][0] = "G#";
        baseNotes[c++][1] = "415";

        baseNotes[c][0] = "A";
        baseNotes[c++][1] = "440";

        baseNotes[c][0] = "A#";
        baseNotes[c++][1] = "466";

        baseNotes[c][0] = "B";
        baseNotes[c++][1] = "494";
    }

    public String[] getFrequencyStrings ()
    {   String[] fs = new String [this.baseNotes.length];

        for (int i=0; i<fs.length; ++i)
            fs[i] = this.baseNotes[i][1];

        return fs;
    }

    public String[] getCombinedStrings ()
    {   String[] cs = new String [this.baseNotes.length];

        for (int i=0; i<cs.length; ++i)
            cs[i] = this.baseNotes[i][0]+"("+this.baseNotes[i][1]+")";

        return cs;
    }

    public int[] getFrequencyInts ()
    {   int[] fi = new int [this.baseNotes.length];

        for (int i=0; i<fi.length; ++i)
            fi[i] = Integer.valueOf(this.baseNotes[i][1]);

        return fi;
    }

    public String[] getToneStrings ()
    {   String[] ts = new String [this.baseNotes.length];

        for (int i=0; i<ts.length; ++i)
            ts[i] = this.baseNotes[i][0];

        return ts;
    }

    public int getFrequencyInt (String t)
    {   for (int i=0; i<this.baseNotes.length; ++i)
            if (this.baseNotes[i][0].equalsIgnoreCase(t))
                return Integer.valueOf(this.baseNotes[i][1]);

        return 0;
    }

    public String getFrequencyString (String t)
    {   for (int i=0; i<this.baseNotes.length; ++i)
            if (this.baseNotes[i][0].equalsIgnoreCase(t))
                return this.baseNotes[i][1];

        return null;
    }

    public String getToneString (String f)
    {   for (int i=0; i<this.baseNotes.length; ++i)
            if (this.baseNotes[i][1].equalsIgnoreCase(f))
                return this.baseNotes[i][0];

        return null;
    }

    public int getFrequencyIndex (String t)
    {   for (int i=0; i<this.baseNotes.length; ++i)
            if (this.baseNotes[i][0].equalsIgnoreCase(t))
                return i-1;

        return 0;
    }

    public int getFrequencyByIndex (int i)
    {   return Integer.valueOf(this.baseNotes[i][1]);
    }
}
