package hive;

import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.Object;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

/**
 * The application's main frame.
 */
public class HiveView extends FrameView
{   public HiveView(SingleFrameApplication app)
    {   super(app);

        initComponents();

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
        this.buttonSerialPort.requestFocus();
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = HiveApp.getApplication().getMainFrame();
            aboutBox = new HiveAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        HiveApp.getApplication().show(aboutBox);
    }

    @Action
    public void showExecutionLog() {
        if (executionLog == null) {
            JFrame mainFrame = HiveApp.getApplication().getMainFrame();
            executionLog = new HiveLogBox(mainFrame, this.log.getText());
            executionLog.setLocationRelativeTo(mainFrame);
        }
        HiveApp.getApplication().show(executionLog);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        panelMoveAction = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        buttonMoveForward = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        buttonMoveBackward = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        buttonTurnLeft = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        buttonTurnRight = new javax.swing.JButton();
        panelScript = new javax.swing.JPanel();
        buttonSaveScript = new javax.swing.JButton();
        buttonRunScript = new javax.swing.JButton();
        buttonClearScript = new javax.swing.JButton();
        buttonLoadScript = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        textPaneScript = new javax.swing.JTextPane();
        panelSensors = new javax.swing.JPanel();
        panelDisplay = new javax.swing.JPanel();
        textDisplay1 = new javax.swing.JTextField();
        textDisplay2 = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        jLabel22 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        iconStatusLED = new javax.swing.JLabel();
        iconFaultLED = new javax.swing.JLabel();
        iconInfraredLED = new javax.swing.JLabel();
        iconU1LED = new javax.swing.JLabel();
        iconU2LED = new javax.swing.JLabel();
        iconU3LED = new javax.swing.JLabel();
        iconU4LED = new javax.swing.JLabel();
        panelRangeSensorSonar = new javax.swing.JPanel();
        jLabel19 = new javax.swing.JLabel();
        textFieldSonarRange = new javax.swing.JTextField();
        panelRangeSensorInfrared = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        textFieldInfraredRangeLeft = new javax.swing.JTextField();
        textFieldInfraredRangeRight = new javax.swing.JTextField();
        panelVisualSensorMotion = new javax.swing.JPanel();
        panelVisualSensorHistogram = new javax.swing.JPanel();
        panelColorSensorLine = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        textFieldLineRangeLeft = new javax.swing.JTextField();
        textFieldLineRangeRight = new javax.swing.JTextField();
        jLabel24 = new javax.swing.JLabel();
        panelSensorAction = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        buttonSwitchCamera = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        buttonSwitchInfrared = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        buttonSwitchSonar = new javax.swing.JButton();
        jLabel21 = new javax.swing.JLabel();
        buttonSwitchLine = new javax.swing.JButton();
        panelSpeakerAction = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        buttonSpeakerBuzz = new javax.swing.JButton();
        jLabel9 = new javax.swing.JLabel();
        buttonSpeakerClick = new javax.swing.JButton();
        jLabel23 = new javax.swing.JLabel();
        buttonSpeakerPlay = new javax.swing.JButton();
        panelComAction = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        buttonSerialPort = new javax.swing.JButton();
        panelSpeakerAction1 = new javax.swing.JPanel();
        jLabel25 = new javax.swing.JLabel();
        buttonSpeakerBuzz1 = new javax.swing.JButton();
        jLabel26 = new javax.swing.JLabel();
        buttonSpeakerClick1 = new javax.swing.JButton();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        settingsMenu = new javax.swing.JMenu();
        serialPortMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        menuItemLog = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(600, 500));

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(hive.HiveApp.class).getContext().getResourceMap(HiveView.class);
        panelMoveAction.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("panelMoveAction.border.title"))); // NOI18N
        panelMoveAction.setName("panelMoveAction"); // NOI18N
        panelMoveAction.setPreferredSize(new java.awt.Dimension(180, 227));
        panelMoveAction.setLayout(new java.awt.GridLayout(0, 2));

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setDoubleBuffered(true);
        jLabel1.setName("jLabel1"); // NOI18N
        jLabel1.setNextFocusableComponent(buttonMoveForward);
        panelMoveAction.add(jLabel1);

        this.buttons.add(this.buttonMoveForward);
        buttonMoveForward.setText(resourceMap.getString("buttonMoveForward.text")); // NOI18N
        buttonMoveForward.setEnabled(false);
        buttonMoveForward.setMaximumSize(new java.awt.Dimension(35, 23));
        buttonMoveForward.setMinimumSize(new java.awt.Dimension(35, 23));
        buttonMoveForward.setName("buttonMoveForward"); // NOI18N
        buttonMoveForward.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonMoveForwardMouseClicked(evt);
            }
        });
        panelMoveAction.add(buttonMoveForward);

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N
        panelMoveAction.add(jLabel2);

        this.buttons.add(this.buttonMoveBackward);
        buttonMoveBackward.setText(resourceMap.getString("buttonMoveBackward.text")); // NOI18N
        buttonMoveBackward.setEnabled(false);
        buttonMoveBackward.setName("buttonMoveBackward"); // NOI18N
        buttonMoveBackward.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonMoveBackwardMouseClicked(evt);
            }
        });
        panelMoveAction.add(buttonMoveBackward);

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N
        panelMoveAction.add(jLabel3);

        this.buttons.add(this.buttonTurnLeft);
        buttonTurnLeft.setText(resourceMap.getString("buttonTurnLeft.text")); // NOI18N
        buttonTurnLeft.setEnabled(false);
        buttonTurnLeft.setName("buttonTurnLeft"); // NOI18N
        buttonTurnLeft.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonTurnLeftMouseClicked(evt);
            }
        });
        panelMoveAction.add(buttonTurnLeft);

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N
        panelMoveAction.add(jLabel4);

        this.buttons.add(this.buttonTurnRight);
        buttonTurnRight.setText(resourceMap.getString("buttonTurnRight.text")); // NOI18N
        buttonTurnRight.setEnabled(false);
        buttonTurnRight.setName("buttonTurnRight"); // NOI18N
        buttonTurnRight.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonTurnRightMouseClicked(evt);
            }
        });
        panelMoveAction.add(buttonTurnRight);

        panelScript.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("scriptPanel.border.title"))); // NOI18N
        panelScript.setName("scriptPanel"); // NOI18N
        panelScript.setPreferredSize(new java.awt.Dimension(180, 227));

        buttonSaveScript.setText(resourceMap.getString("buttonSaveScript.text")); // NOI18N
        buttonSaveScript.setName("buttonSaveScript"); // NOI18N
        buttonSaveScript.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSaveScriptMouseClicked(evt);
            }
        });

        this.buttons.add(this.buttonRunScript);
        buttonRunScript.setText(resourceMap.getString("buttonRunScript.text")); // NOI18N
        buttonRunScript.setEnabled(false);
        buttonRunScript.setMaximumSize(new java.awt.Dimension(69, 23));
        buttonRunScript.setMinimumSize(new java.awt.Dimension(69, 23));
        buttonRunScript.setName("buttonRunScript"); // NOI18N
        buttonRunScript.setPreferredSize(new java.awt.Dimension(69, 23));

        buttonClearScript.setLabel(resourceMap.getString("buttonClearScript.label")); // NOI18N
        buttonClearScript.setMaximumSize(new java.awt.Dimension(69, 23));
        buttonClearScript.setMinimumSize(new java.awt.Dimension(69, 23));
        buttonClearScript.setName("buttonClearScript"); // NOI18N
        buttonClearScript.setPreferredSize(new java.awt.Dimension(69, 23));
        buttonClearScript.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonClearScriptMouseClicked(evt);
            }
        });

        buttonLoadScript.setText(resourceMap.getString("buttonLoadScript.text")); // NOI18N
        buttonLoadScript.setMaximumSize(new java.awt.Dimension(69, 23));
        buttonLoadScript.setMinimumSize(new java.awt.Dimension(69, 23));
        buttonLoadScript.setName("buttonLoadScript"); // NOI18N
        buttonLoadScript.setPreferredSize(new java.awt.Dimension(69, 23));

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        textPaneScript.setDoubleBuffered(true);
        textPaneScript.setDragEnabled(true);
        textPaneScript.setName("textPaneScript"); // NOI18N
        jScrollPane1.setViewportView(textPaneScript);

        javax.swing.GroupLayout panelScriptLayout = new javax.swing.GroupLayout(panelScript);
        panelScript.setLayout(panelScriptLayout);
        panelScriptLayout.setHorizontalGroup(
            panelScriptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelScriptLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelScriptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 529, Short.MAX_VALUE)
                    .addGroup(panelScriptLayout.createSequentialGroup()
                        .addComponent(buttonLoadScript, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(buttonSaveScript, javax.swing.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE)
                        .addGap(22, 22, 22)
                        .addComponent(buttonRunScript, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(buttonClearScript, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        panelScriptLayout.setVerticalGroup(
            panelScriptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelScriptLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 517, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addGroup(panelScriptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(buttonLoadScript, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(buttonSaveScript)
                    .addComponent(buttonClearScript, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(buttonRunScript, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        panelSensors.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("sensorPanel.border.title"))); // NOI18N
        panelSensors.setName("sensorPanel"); // NOI18N
        panelSensors.setPreferredSize(new java.awt.Dimension(180, 227));

        panelDisplay.setBackground(resourceMap.getColor("panelDisplay.background")); // NOI18N
        panelDisplay.setName("panelDisplay"); // NOI18N

        textDisplay1.setBackground(resourceMap.getColor("textDisplay1.background")); // NOI18N
        textDisplay1.setEditable(false);
        textDisplay1.setText(resourceMap.getString("textDisplay1.text")); // NOI18N
        textDisplay1.setName("textDisplay1"); // NOI18N

        textDisplay2.setBackground(resourceMap.getColor("textDisplay2.background")); // NOI18N
        textDisplay2.setEditable(false);
        textDisplay2.setText(resourceMap.getString("textDisplay2.text")); // NOI18N
        textDisplay2.setName("textDisplay2"); // NOI18N

        javax.swing.GroupLayout panelDisplayLayout = new javax.swing.GroupLayout(panelDisplay);
        panelDisplay.setLayout(panelDisplayLayout);
        panelDisplayLayout.setHorizontalGroup(
            panelDisplayLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelDisplayLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelDisplayLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(textDisplay1, javax.swing.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                    .addComponent(textDisplay2, javax.swing.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE))
                .addContainerGap())
        );
        panelDisplayLayout.setVerticalGroup(
            panelDisplayLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelDisplayLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(textDisplay1, javax.swing.GroupLayout.DEFAULT_SIZE, 32, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(textDisplay2, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel1.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setLayout(new java.awt.GridLayout(2, 7));

        jLabel17.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel17.setText(resourceMap.getString("jLabel17.text")); // NOI18N
        jLabel17.setName("jLabel17"); // NOI18N
        jPanel1.add(jLabel17);

        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel16.setText(resourceMap.getString("jLabel16.text")); // NOI18N
        jLabel16.setName("jLabel16"); // NOI18N
        jPanel1.add(jLabel16);

        jLabel15.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel15.setText(resourceMap.getString("jLabel15.text")); // NOI18N
        jLabel15.setName("jLabel15"); // NOI18N
        jPanel1.add(jLabel15);

        jLabel13.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel13.setText(resourceMap.getString("jLabel13.text")); // NOI18N
        jLabel13.setName("jLabel13"); // NOI18N
        jPanel1.add(jLabel13);

        jLabel18.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel18.setText(resourceMap.getString("jLabel18.text")); // NOI18N
        jLabel18.setName("jLabel18"); // NOI18N
        jPanel1.add(jLabel18);

        jLabel22.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel22.setText(resourceMap.getString("jLabel22.text")); // NOI18N
        jLabel22.setName("jLabel22"); // NOI18N
        jPanel1.add(jLabel22);

        jLabel14.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel14.setText(resourceMap.getString("jLabel14.text")); // NOI18N
        jLabel14.setName("jLabel14"); // NOI18N
        jPanel1.add(jLabel14);

        iconStatusLED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconStatusLED.setIcon(resourceMap.getIcon("iconStatusLED.icon")); // NOI18N
        iconStatusLED.setText(resourceMap.getString("iconStatusLED.text")); // NOI18N
        iconStatusLED.setName("iconStatusLED"); // NOI18N
        jPanel1.add(iconStatusLED);

        iconFaultLED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconFaultLED.setIcon(resourceMap.getIcon("iconFaultLED.icon")); // NOI18N
        iconFaultLED.setText(resourceMap.getString("iconFaultLED.text")); // NOI18N
        iconFaultLED.setName("iconFaultLED"); // NOI18N
        jPanel1.add(iconFaultLED);

        iconInfraredLED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconInfraredLED.setIcon(resourceMap.getIcon("iconInfraredLED.icon")); // NOI18N
        iconInfraredLED.setText(resourceMap.getString("iconInfraredLED.text")); // NOI18N
        iconInfraredLED.setName("iconInfraredLED"); // NOI18N
        jPanel1.add(iconInfraredLED);

        iconU1LED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconU1LED.setIcon(resourceMap.getIcon("iconU1LED.icon")); // NOI18N
        iconU1LED.setText(resourceMap.getString("iconU1LED.text")); // NOI18N
        iconU1LED.setName("iconU1LED"); // NOI18N
        jPanel1.add(iconU1LED);

        iconU2LED.setBackground(resourceMap.getColor("iconU2LED.background")); // NOI18N
        iconU2LED.setForeground(resourceMap.getColor("iconU2LED.foreground")); // NOI18N
        iconU2LED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconU2LED.setIcon(resourceMap.getIcon("iconU2LED.icon")); // NOI18N
        iconU2LED.setText(resourceMap.getString("iconU2LED.text")); // NOI18N
        iconU2LED.setName("iconU2LED"); // NOI18N
        jPanel1.add(iconU2LED);

        iconU3LED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconU3LED.setIcon(resourceMap.getIcon("iconU3LED.icon")); // NOI18N
        iconU3LED.setText(resourceMap.getString("iconU3LED.text")); // NOI18N
        iconU3LED.setName("iconU3LED"); // NOI18N
        jPanel1.add(iconU3LED);

        iconU4LED.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        iconU4LED.setIcon(resourceMap.getIcon("iconU4LED.icon")); // NOI18N
        iconU4LED.setText(resourceMap.getString("iconU4LED.text")); // NOI18N
        iconU4LED.setName("iconU4LED"); // NOI18N
        jPanel1.add(iconU4LED);

        panelRangeSensorSonar.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("panelRangeSensorSonar.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        panelRangeSensorSonar.setName("panelRangeSensorSonar"); // NOI18N

        jLabel19.setText(resourceMap.getString("jLabel19.text")); // NOI18N
        jLabel19.setName("jLabel19"); // NOI18N

        textFieldSonarRange.setBackground(resourceMap.getColor("textFieldInfraredRangeLeft.background")); // NOI18N
        textFieldSonarRange.setEditable(false);
        textFieldSonarRange.setDisabledTextColor(resourceMap.getColor("textFieldSonarRange.disabledTextColor")); // NOI18N
        textFieldSonarRange.setName("textFieldSonarRange"); // NOI18N

        javax.swing.GroupLayout panelRangeSensorSonarLayout = new javax.swing.GroupLayout(panelRangeSensorSonar);
        panelRangeSensorSonar.setLayout(panelRangeSensorSonarLayout);
        panelRangeSensorSonarLayout.setHorizontalGroup(
            panelRangeSensorSonarLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelRangeSensorSonarLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel19)
                .addGap(18, 18, 18)
                .addComponent(textFieldSonarRange, javax.swing.GroupLayout.DEFAULT_SIZE, 344, Short.MAX_VALUE)
                .addContainerGap())
        );
        panelRangeSensorSonarLayout.setVerticalGroup(
            panelRangeSensorSonarLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelRangeSensorSonarLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jLabel19)
                .addComponent(textFieldSonarRange, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        panelRangeSensorInfrared.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("panelRangeSensorInfrared.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        panelRangeSensorInfrared.setName("panelRangeSensorInfrared"); // NOI18N

        jLabel11.setText(resourceMap.getString("jLabel11.text")); // NOI18N
        jLabel11.setName("jLabel11"); // NOI18N

        jLabel12.setText(resourceMap.getString("jLabel12.text")); // NOI18N
        jLabel12.setName("jLabel12"); // NOI18N

        textFieldInfraredRangeLeft.setBackground(resourceMap.getColor("textFieldInfraredRangeLeft.background")); // NOI18N
        textFieldInfraredRangeLeft.setEditable(false);
        textFieldInfraredRangeLeft.setText(resourceMap.getString("textFieldInfraredRangeLeft.text")); // NOI18N
        textFieldInfraredRangeLeft.setName("textFieldInfraredRangeLeft"); // NOI18N

        textFieldInfraredRangeRight.setBackground(resourceMap.getColor("textFieldInfraredRangeLeft.background")); // NOI18N
        textFieldInfraredRangeRight.setEditable(false);
        textFieldInfraredRangeRight.setText(resourceMap.getString("textFieldInfraredRangeRight.text")); // NOI18N
        textFieldInfraredRangeRight.setDisabledTextColor(resourceMap.getColor("textFieldInfraredRangeRight.disabledTextColor")); // NOI18N
        textFieldInfraredRangeRight.setName("textFieldInfraredRangeRight"); // NOI18N

        javax.swing.GroupLayout panelRangeSensorInfraredLayout = new javax.swing.GroupLayout(panelRangeSensorInfrared);
        panelRangeSensorInfrared.setLayout(panelRangeSensorInfraredLayout);
        panelRangeSensorInfraredLayout.setHorizontalGroup(
            panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelRangeSensorInfraredLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel11)
                    .addComponent(jLabel12))
                .addGap(24, 24, 24)
                .addGroup(panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(textFieldInfraredRangeLeft, javax.swing.GroupLayout.DEFAULT_SIZE, 341, Short.MAX_VALUE)
                    .addComponent(textFieldInfraredRangeRight, javax.swing.GroupLayout.DEFAULT_SIZE, 341, Short.MAX_VALUE))
                .addContainerGap())
        );
        panelRangeSensorInfraredLayout.setVerticalGroup(
            panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelRangeSensorInfraredLayout.createSequentialGroup()
                .addGroup(panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(textFieldInfraredRangeLeft, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel11))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelRangeSensorInfraredLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(textFieldInfraredRangeRight, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel12))
                .addContainerGap(5, Short.MAX_VALUE))
        );

        panelVisualSensorMotion.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("panelVisualSensorMotion.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        panelVisualSensorMotion.setName("panelVisualSensorMotion"); // NOI18N
        panelVisualSensorMotion.setPreferredSize(new java.awt.Dimension(200, 200));

        javax.swing.GroupLayout panelVisualSensorMotionLayout = new javax.swing.GroupLayout(panelVisualSensorMotion);
        panelVisualSensorMotion.setLayout(panelVisualSensorMotionLayout);
        panelVisualSensorMotionLayout.setHorizontalGroup(
            panelVisualSensorMotionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 198, Short.MAX_VALUE)
        );
        panelVisualSensorMotionLayout.setVerticalGroup(
            panelVisualSensorMotionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 170, Short.MAX_VALUE)
        );

        panelVisualSensorHistogram.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("panelVisualSensorHistogram.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        panelVisualSensorHistogram.setName("panelVisualSensorHistogram"); // NOI18N
        panelVisualSensorHistogram.setPreferredSize(new java.awt.Dimension(200, 200));

        javax.swing.GroupLayout panelVisualSensorHistogramLayout = new javax.swing.GroupLayout(panelVisualSensorHistogram);
        panelVisualSensorHistogram.setLayout(panelVisualSensorHistogramLayout);
        panelVisualSensorHistogramLayout.setHorizontalGroup(
            panelVisualSensorHistogramLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 196, Short.MAX_VALUE)
        );
        panelVisualSensorHistogramLayout.setVerticalGroup(
            panelVisualSensorHistogramLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 170, Short.MAX_VALUE)
        );

        panelColorSensorLine.setBorder(javax.swing.BorderFactory.createTitledBorder(null, resourceMap.getString("panelColorSensorLine.border.title"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP)); // NOI18N
        panelColorSensorLine.setName("panelColorSensorLine"); // NOI18N

        jLabel20.setText(resourceMap.getString("jLabel20.text")); // NOI18N
        jLabel20.setName("jLabel20"); // NOI18N

        textFieldLineRangeLeft.setBackground(resourceMap.getColor("textFieldInfraredRangeLeft.background")); // NOI18N
        textFieldLineRangeLeft.setEditable(false);
        textFieldLineRangeLeft.setDisabledTextColor(resourceMap.getColor("textFieldLineRangeLeft.disabledTextColor")); // NOI18N
        textFieldLineRangeLeft.setName("textFieldLineRangeLeft"); // NOI18N

        textFieldLineRangeRight.setBackground(resourceMap.getColor("textFieldInfraredRangeLeft.background")); // NOI18N
        textFieldLineRangeRight.setEditable(false);
        textFieldLineRangeRight.setDisabledTextColor(resourceMap.getColor("textFieldLineRangeRight.disabledTextColor")); // NOI18N
        textFieldLineRangeRight.setName("textFieldLineRangeRight"); // NOI18N

        jLabel24.setText(resourceMap.getString("jLabel24.text")); // NOI18N
        jLabel24.setName("jLabel24"); // NOI18N

        javax.swing.GroupLayout panelColorSensorLineLayout = new javax.swing.GroupLayout(panelColorSensorLine);
        panelColorSensorLine.setLayout(panelColorSensorLineLayout);
        panelColorSensorLineLayout.setHorizontalGroup(
            panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelColorSensorLineLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel20)
                    .addComponent(jLabel24))
                .addGap(22, 22, 22)
                .addGroup(panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(textFieldLineRangeRight, javax.swing.GroupLayout.PREFERRED_SIZE, 344, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(textFieldLineRangeLeft, javax.swing.GroupLayout.PREFERRED_SIZE, 344, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(19, 19, 19))
        );
        panelColorSensorLineLayout.setVerticalGroup(
            panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelColorSensorLineLayout.createSequentialGroup()
                .addGroup(panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel20)
                    .addComponent(textFieldLineRangeLeft, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelColorSensorLineLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(textFieldLineRangeRight, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel24))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout panelSensorsLayout = new javax.swing.GroupLayout(panelSensors);
        panelSensors.setLayout(panelSensorsLayout);
        panelSensorsLayout.setHorizontalGroup(
            panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelSensorsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(panelColorSensorLine, javax.swing.GroupLayout.DEFAULT_SIZE, 442, Short.MAX_VALUE)
                    .addGroup(panelSensorsLayout.createSequentialGroup()
                        .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(panelDisplay, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(panelVisualSensorMotion, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 214, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE)
                            .addComponent(panelVisualSensorHistogram, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE))
                        .addGap(10, 10, 10))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelSensorsLayout.createSequentialGroup()
                        .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(panelRangeSensorInfrared, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(panelRangeSensorSonar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())))
        );
        panelSensorsLayout.setVerticalGroup(
            panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelSensorsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(panelDisplay, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(panelSensorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(panelVisualSensorMotion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(panelVisualSensorHistogram, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(panelRangeSensorInfrared, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(panelRangeSensorSonar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(panelColorSensorLine, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(20, Short.MAX_VALUE))
        );

        panelSensorAction.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("panelSensorAction.border.title"))); // NOI18N
        panelSensorAction.setName("panelSensorAction"); // NOI18N
        panelSensorAction.setPreferredSize(new java.awt.Dimension(180, 227));
        panelSensorAction.setLayout(new java.awt.GridLayout(0, 2));

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setDoubleBuffered(true);
        jLabel5.setName("jLabel5"); // NOI18N
        jLabel5.setNextFocusableComponent(buttonMoveForward);
        panelSensorAction.add(jLabel5);

        this.buttons.add(this.buttonSwitchCamera);
        buttonSwitchCamera.setText(resourceMap.getString("buttonSwitchCamera.text")); // NOI18N
        buttonSwitchCamera.setEnabled(false);
        buttonSwitchCamera.setMaximumSize(new java.awt.Dimension(35, 23));
        buttonSwitchCamera.setMinimumSize(new java.awt.Dimension(35, 23));
        buttonSwitchCamera.setName("buttonSwitchCamera"); // NOI18N
        panelSensorAction.add(buttonSwitchCamera);

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N
        panelSensorAction.add(jLabel6);

        this.buttons.add(this.buttonSwitchInfrared);
        buttonSwitchInfrared.setText(resourceMap.getString("buttonSwitchInfrared.text")); // NOI18N
        buttonSwitchInfrared.setEnabled(false);
        buttonSwitchInfrared.setName("buttonSwitchInfrared"); // NOI18N
        buttonSwitchInfrared.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSwitchInfraredMouseClicked(evt);
            }
        });
        panelSensorAction.add(buttonSwitchInfrared);

        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N
        panelSensorAction.add(jLabel7);

        this.buttons.add(this.buttonSwitchSonar);
        buttonSwitchSonar.setText(resourceMap.getString("buttonSwitchSonar.text")); // NOI18N
        buttonSwitchSonar.setEnabled(false);
        buttonSwitchSonar.setName("buttonSwitchSonar"); // NOI18N
        buttonSwitchSonar.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSwitchSonarMouseClicked(evt);
            }
        });
        panelSensorAction.add(buttonSwitchSonar);

        jLabel21.setText(resourceMap.getString("jLabel21.text")); // NOI18N
        jLabel21.setName("jLabel21"); // NOI18N
        panelSensorAction.add(jLabel21);

        this.buttons.add(this.buttonSwitchLine);
        buttonSwitchLine.setText(resourceMap.getString("buttonSwitchLine.text")); // NOI18N
        buttonSwitchLine.setEnabled(false);
        buttonSwitchLine.setName("buttonSwitchLine"); // NOI18N
        buttonSwitchLine.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSwitchLineMouseClicked(evt);
            }
        });
        panelSensorAction.add(buttonSwitchLine);

        panelSpeakerAction.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("panelSpeakerAction.border.title"))); // NOI18N
        panelSpeakerAction.setName("panelSpeakerAction"); // NOI18N
        panelSpeakerAction.setPreferredSize(new java.awt.Dimension(180, 227));
        panelSpeakerAction.setLayout(new java.awt.GridLayout(0, 2));

        jLabel8.setText(resourceMap.getString("jLabel8.text")); // NOI18N
        jLabel8.setDoubleBuffered(true);
        jLabel8.setName("jLabel8"); // NOI18N
        jLabel8.setNextFocusableComponent(buttonMoveForward);
        panelSpeakerAction.add(jLabel8);

        this.buttons.add(this.buttonSpeakerBuzz);
        buttonSpeakerBuzz.setText(resourceMap.getString("buttonSpeakerBuzz.text")); // NOI18N
        buttonSpeakerBuzz.setEnabled(false);
        buttonSpeakerBuzz.setMaximumSize(new java.awt.Dimension(35, 23));
        buttonSpeakerBuzz.setMinimumSize(new java.awt.Dimension(35, 23));
        buttonSpeakerBuzz.setName("buttonSpeakerBuzz"); // NOI18N
        buttonSpeakerBuzz.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSpeakerBuzzMouseClicked(evt);
            }
        });
        panelSpeakerAction.add(buttonSpeakerBuzz);

        jLabel9.setText(resourceMap.getString("jLabel9.text")); // NOI18N
        jLabel9.setName("jLabel9"); // NOI18N
        panelSpeakerAction.add(jLabel9);

        this.buttons.add(this.buttonSpeakerClick);
        buttonSpeakerClick.setText(resourceMap.getString("buttonSpeakerClick.text")); // NOI18N
        buttonSpeakerClick.setEnabled(false);
        buttonSpeakerClick.setName("buttonSpeakerClick"); // NOI18N
        buttonSpeakerClick.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSpeakerClickMouseClicked(evt);
            }
        });
        panelSpeakerAction.add(buttonSpeakerClick);

        jLabel23.setText(resourceMap.getString("jLabel23.text")); // NOI18N
        jLabel23.setName("jLabel23"); // NOI18N
        panelSpeakerAction.add(jLabel23);

        this.buttons.add(this.buttonSpeakerPlay);
        buttonSpeakerPlay.setText(resourceMap.getString("buttonSpeakerPlay.text")); // NOI18N
        buttonSpeakerPlay.setActionCommand(resourceMap.getString("buttonSpeakerPlay.actionCommand")); // NOI18N
        buttonSpeakerPlay.setEnabled(false);
        buttonSpeakerPlay.setName("buttonSpeakerPlay"); // NOI18N
        buttonSpeakerPlay.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSpeakerPlayMouseClicked(evt);
            }
        });
        panelSpeakerAction.add(buttonSpeakerPlay);

        panelComAction.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("panelComAction.border.title"))); // NOI18N
        panelComAction.setName("panelComAction"); // NOI18N
        panelComAction.setLayout(new java.awt.GridLayout(1, 2));

        jLabel10.setText(resourceMap.getString("jLabel10.text")); // NOI18N
        jLabel10.setName("jLabel10"); // NOI18N
        panelComAction.add(jLabel10);

        this.buttons.add(this.buttonSerialPort);
        buttonSerialPort.setFont(resourceMap.getFont("buttonSerialPort.font")); // NOI18N
        buttonSerialPort.setText(resourceMap.getString("buttonSerialPort.text")); // NOI18N
        buttonSerialPort.setEnabled(false);
        buttonSerialPort.setName("buttonSerialPort"); // NOI18N
        buttonSerialPort.setPreferredSize(new java.awt.Dimension(55, 23));
        buttonSerialPort.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSerialPortMouseClicked(evt);
            }
        });
        panelComAction.add(buttonSerialPort);

        panelSpeakerAction1.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("panelSpeakerAction1.border.title"))); // NOI18N
        panelSpeakerAction1.setName("panelSpeakerAction1"); // NOI18N
        panelSpeakerAction1.setPreferredSize(new java.awt.Dimension(180, 227));
        panelSpeakerAction1.setLayout(new java.awt.GridLayout(0, 2));

        jLabel25.setText(resourceMap.getString("jLabel25.text")); // NOI18N
        jLabel25.setDoubleBuffered(true);
        jLabel25.setName("jLabel25"); // NOI18N
        jLabel25.setNextFocusableComponent(buttonMoveForward);
        panelSpeakerAction1.add(jLabel25);

        this.buttons.add(this.buttonSpeakerBuzz);
        buttonSpeakerBuzz1.setText(resourceMap.getString("buttonSpeakerBuzz1.text")); // NOI18N
        buttonSpeakerBuzz1.setEnabled(false);
        buttonSpeakerBuzz1.setMaximumSize(new java.awt.Dimension(35, 23));
        buttonSpeakerBuzz1.setMinimumSize(new java.awt.Dimension(35, 23));
        buttonSpeakerBuzz1.setName("buttonSpeakerBuzz1"); // NOI18N
        buttonSpeakerBuzz1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSpeakerBuzz1MouseClicked(evt);
            }
        });
        panelSpeakerAction1.add(buttonSpeakerBuzz1);

        jLabel26.setText(resourceMap.getString("jLabel26.text")); // NOI18N
        jLabel26.setName("jLabel26"); // NOI18N
        panelSpeakerAction1.add(jLabel26);

        this.buttons.add(this.buttonSpeakerClick);
        buttonSpeakerClick1.setText(resourceMap.getString("buttonSpeakerClick1.text")); // NOI18N
        buttonSpeakerClick1.setEnabled(false);
        buttonSpeakerClick1.setName("buttonSpeakerClick1"); // NOI18N
        buttonSpeakerClick1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonSpeakerClick1MouseClicked(evt);
            }
        });
        panelSpeakerAction1.add(buttonSpeakerClick1);

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(panelSpeakerAction1, javax.swing.GroupLayout.DEFAULT_SIZE, 222, Short.MAX_VALUE)
                    .addComponent(panelSpeakerAction, javax.swing.GroupLayout.DEFAULT_SIZE, 222, Short.MAX_VALUE)
                    .addComponent(panelSensorAction, javax.swing.GroupLayout.DEFAULT_SIZE, 222, Short.MAX_VALUE)
                    .addComponent(panelMoveAction, 0, 222, Short.MAX_VALUE)
                    .addComponent(panelComAction, javax.swing.GroupLayout.DEFAULT_SIZE, 222, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(panelScript, javax.swing.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(panelSensors, javax.swing.GroupLayout.PREFERRED_SIZE, 468, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(panelScript, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 610, Short.MAX_VALUE)
                    .addComponent(panelSensors, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 610, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup()
                        .addComponent(panelComAction, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(panelMoveAction, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(panelSensorAction, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(panelSpeakerAction, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(panelSpeakerAction1, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        panelMoveAction.getAccessibleContext().setAccessibleName(resourceMap.getString("panelMoveAction.AccessibleContext.accessibleName")); // NOI18N

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(hive.HiveApp.class).getContext().getActionMap(HiveView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        settingsMenu.setText(resourceMap.getString("settingsMenu.text")); // NOI18N
        settingsMenu.setName("settingsMenu"); // NOI18N

        serialPortMenuItem.setAction(actionMap.get("selectedSerialPortMenuItem")); // NOI18N
        serialPortMenuItem.setText(resourceMap.getString("serialPortMenuItem.text")); // NOI18N
        serialPortMenuItem.setName("serialPortMenuItem"); // NOI18N
        settingsMenu.add(serialPortMenuItem);

        menuBar.add(settingsMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("menuItemAbout"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuItemLog.setAction(actionMap.get("showExecutionLog")); // NOI18N
        menuItemLog.setText(resourceMap.getString("menuItemLog.text")); // NOI18N
        menuItemLog.setToolTipText(resourceMap.getString("menuItemLog.toolTipText")); // NOI18N
        menuItemLog.setName("menuItemLog"); // NOI18N
        helpMenu.add(menuItemLog);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N
        statusPanel.setPreferredSize(new java.awt.Dimension(1720, 40));

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setText(resourceMap.getString("statusMessageLabel.text")); // NOI18N
        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        statusAnimationLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 1291, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(progressBar, javax.swing.GroupLayout.DEFAULT_SIZE, 1078, Short.MAX_VALUE)
                .addGap(84, 84, 84)
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(statusAnimationLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(statusMessageLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 26, Short.MAX_VALUE))
                .addContainerGap())
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    public JTextField getTextDisplay2() {
        return textDisplay2;
    }
    public JTextField getTextDisplay1() {
        return textDisplay1;
    }

    private void buttonSaveScriptMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSaveScriptMouseClicked
        // TODO add your handling code here:
        File file = null;
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter fcFilter = new ExtensionFileFilter("csv");
        fc.setFileFilter((FileFilter)fcFilter);

        if (fc.showSaveDialog(null) == JFileChooser.APPROVE_OPTION)
        {   //SET THE PROGRESSBAR
            this.progressBar.setVisible(true);
            //this.progressBar.setMaximum(/*INSER THE NUMBER OF ELEMENTS IN THE PARSER*/);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);

            if(fcFilter.accept(fc.getSelectedFile()))
                file = fc.getSelectedFile();
            else
                file = new File (fc.getSelectedFile().getAbsolutePath() + "." + fcFilter.getExtension());

            //LOAD JTABLE INTO FILE
            try
            {   if (!file.exists())
                    file.createNewFile();

                BufferedWriter fileIn = new BufferedWriter(new FileWriter(file.getAbsoluteFile()));

                /*for (int i=0; i<this.tableScript.getRowCount(); ++i)
                {   for (int j=0; j<this.tableScript.getColumnCount(); ++j)
                {   fileIn.write((String)this.tableScript.getValueAt(i, j) + ",");
                this.progressBar.setValue(this.progressBar.getValue()+1);
                }*/
                    fileIn.write("\n");
                //}

                fileIn.flush();
                fileIn.close();
            }
            catch (Exception e)
            {   System.err.println("Error: " + e.getMessage());
            }

            log.append("Saving: " + file.getAbsolutePath() + "." + "\n");
            this.progressBar.setVisible(false);
        }
        else
            log.append("Save command cancelled by user." + "\n");

        log.setCaretPosition(log.getDocument().getLength());
    }//GEN-LAST:event_buttonSaveScriptMouseClicked

    private void buttonClearScriptMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonClearScriptMouseClicked
        this.textPaneScript.setText("");
    }//GEN-LAST:event_buttonClearScriptMouseClicked

    private void buttonMoveForwardMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonMoveForwardMouseClicked
        if(this.flagForward)
        {   this.buttonMoveForward.setText("stop");
            this.serial.writeOut(new String(getCommand('m', 'f', '0', '0', '0', "")));
        }
        else
        {   this.buttonMoveForward.setText("start");
            this.serial.writeOut(new String(getCommand ('m', 's', '0', '0', '0', "")));
        }
        this.flagForward = !this.flagForward;
}//GEN-LAST:event_buttonMoveForwardMouseClicked

    private void buttonMoveBackwardMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonMoveBackwardMouseClicked
        if(this.flagBackward)
        {   this.buttonMoveBackward.setText("stop");
            this.serial.writeOut(new String(getCommand ('m', 'b', '0', '0', '0', "")));
        }
        else
        {   this.buttonMoveBackward.setText("start");
            this.serial.writeOut(new String(getCommand ('m', 's', '0', '0', '0', "")));
        }
        this.flagBackward = !this.flagBackward;
}//GEN-LAST:event_buttonMoveBackwardMouseClicked

    private void buttonTurnLeftMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonTurnLeftMouseClicked
        if(this.flagLeft)
        {   this.buttonTurnLeft.setText("stop");
            this.serial.writeOut(new String(getCommand ('m', 'l', '0', '0', '0', "")));
        }
        else
        {   this.buttonTurnLeft.setText("start");
            this.serial.writeOut(new String(getCommand ('m', 's', '0', '0', '0', "")));
        }
        this.flagLeft = !this.flagLeft;
}//GEN-LAST:event_buttonTurnLeftMouseClicked

    private void buttonTurnRightMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonTurnRightMouseClicked
        if(this.flagRight)
        {   this.buttonTurnRight.setText("stop");
            this.serial.writeOut(new String(getCommand ('m', 'r', '0', '0', '0', "")));
        }
        else
        {   this.buttonTurnRight.setText("start");
            this.serial.writeOut(new String(getCommand ('m', 's', '0', '0', '0', "")));
        }
        this.flagRight = !this.flagRight;
}//GEN-LAST:event_buttonTurnRightMouseClicked

    private void buttonSpeakerBuzzMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSpeakerBuzzMouseClicked
        if (this.flagBuzz == START)
        {   this.flagBuzz = STOP;
            this.buttonSpeakerBuzz.setText("stop");
            this.serial.writeOut(new String(getCommand ('s', 'b', '0', '0', '0', "")));
        }
        else
        {   this.flagBuzz = START;
            this.buttonSpeakerBuzz.setText("start");
            this.serial.writeOut(new String(getCommand ('s', 's', '0', '0', '0', "")));
        }
}//GEN-LAST:event_buttonSpeakerBuzzMouseClicked

    private void buttonSpeakerClickMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSpeakerClickMouseClicked
        if(this.flagClick == START)
        {   this.flagClick = STOP;
            this.buttonSpeakerClick.setText("stop");
            this.serial.writeOut(new String(getCommand ('s', 'c', '0', '0', '0', "")));
        }
        else
        {   this.flagClick = START;
            this.buttonSpeakerClick.setText("start");
            this.serial.writeOut(new String(getCommand ('s', 's', '0', '0', '0', "")));
        }
}//GEN-LAST:event_buttonSpeakerClickMouseClicked

    private void buttonSwitchInfraredMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSwitchInfraredMouseClicked
        if (this.flagInfrared == START)
        {    this.compileReadRangeCommand('i');
             this.flagInfrared = STOP;
             this.buttonSwitchInfrared.setText("stop");
        }
        else
        {    this.compileReadRangeCommand('i');
             this.flagInfrared = START;
             this.buttonSwitchInfrared.setText("start");
        }
}//GEN-LAST:event_buttonSwitchInfraredMouseClicked

    private void buttonSerialPortMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSerialPortMouseClicked
        try
        {   if (this.flagSerial == START)
            {   if(this.portId == null)
                    this.serial = new HiveSerialComm(this);
                else
                    this.serial = new HiveSerialComm(this, this.portId);

                this.serialThread = new Thread (this.serial);
                this.serialThread.setPriority(Thread.NORM_PRIORITY);
                this.serialThread.start();
                this.serialThread.isAlive(); //FIRE THE LISTENER
                this.flagSerial = STOP;
                this.buttonSerialPort.setText("Disconnect");
                this.statusMessageLabel.setText("CONNECTED");
                this.statusAnimationLabel.setIcon(idleIcon);

                this.enableAll(this.START, null);
            }
            else
            {   this.serial.close();
                this.serial = null;
                this.flagSerial = START;
                this.buttonSerialPort.setText("Connect");
                this.statusMessageLabel.setText("DISCONNECTED");
                this.enableAll(this.STOP, evt.getSource());
        }   }
        catch (Throwable t) {t.printStackTrace();}
    }//GEN-LAST:event_buttonSerialPortMouseClicked

    private void enableAll (boolean s, Object o)
    {   Iterator<JButton> i = this.buttons.iterator();
        JButton b = null;
        while(i.hasNext())
        {   b = i.next();
            if(b != (JButton)o)
                 b.setEnabled(s);
            else b.setEnabled(!s);
        }
    }

    private void buttonSpeakerPlayMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSpeakerPlayMouseClicked
        File file = null;
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter fcFilter = new ExtensionFileFilter("xml");
        fc.setFileFilter((FileFilter)fcFilter);

        if (fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
        {   if (fcFilter.accept(fc.getSelectedFile()))
                file = fc.getSelectedFile();
            else
                file = new File (fc.getSelectedFile().getAbsolutePath() + "." + fcFilter.getExtension());

            try
            {   if (file.exists())
                {   //String[] song = this.parseMusicArrayToSerialCommands(this.parseXMLtoMusicArray(new FileInputStream(file)));
                    //SET THE PROGRESSBAR
                    //this.progressBar.setValue(0);
                    //this.progressBar.setMaximum(song.length-1);
                    //this.progressBar.setStringPainted(true);
                    //this.progressBar.setVisible(true);
                    this.serial.writeOut("spi0t0"+(byte)3+'d'+(byte)3);
                    //for (int i=0; i<song.length; ++i)
                    //{   this.serial.writeOut(song[i]);
                        //this.progressBar.setValue(i);
                        //System.out.println(song[i]);
                        //int start = song[i].indexOf("t0")+2;
                        //int end   = song[i].indexOf("d");
                        //Thread.sleep(Integer.parseInt(song[i].substring(start, end)));
                    //}
            }   }
            catch (Exception e)
            {   System.err.println("Error: " + e.getMessage());
            }

            this.progressBar.setVisible(false);
        }
    }//GEN-LAST:event_buttonSpeakerPlayMouseClicked

    private void buttonSwitchSonarMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSwitchSonarMouseClicked
        if (this.flagSonar == START)
        {    this.compileReadRangeCommand('s');
             this.flagSonar = STOP;
             this.buttonSwitchSonar.setText("stop");
        }
        else
        {    this.compileReadRangeCommand('s');
             this.flagSonar = START;
             this.buttonSwitchSonar.setText("start");
        }
    }//GEN-LAST:event_buttonSwitchSonarMouseClicked

    private void buttonSwitchLineMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSwitchLineMouseClicked
        if (this.flagLine == START)
        {    this.compileReadRangeCommand('l');
             this.flagLine = STOP;
             this.buttonSwitchLine.setText("stop");
        }
        else
        {    this.compileReadRangeCommand('l');
             this.flagLine = START;
             this.buttonSwitchLine.setText("start");
        }
    }//GEN-LAST:event_buttonSwitchLineMouseClicked

    private void buttonSpeakerBuzz1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSpeakerBuzz1MouseClicked
        // TODO add your handling code here:
    }//GEN-LAST:event_buttonSpeakerBuzz1MouseClicked

    private void buttonSpeakerClick1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buttonSpeakerClick1MouseClicked
        // TODO add your handling code here:
    }//GEN-LAST:event_buttonSpeakerClick1MouseClicked
    
    public String[] parseMusicArrayToSerialCommands (ArrayList<String[]> al)
    {   String[] sc = new String[al.size()];

        for(int i=0; i<sc.length; ++i)
            sc[i] = ""+'s'+'p'+'i'+'0'+'t'+'0'+Integer.parseInt(al.get(i)[1])+'d'+Integer.parseInt(al.get(i)[0]);

        return sc;
    }

    public ArrayList<String[]> parseXMLtoMusicArray (FileInputStream in) throws IOException, StringIndexOutOfBoundsException
    {   ArrayList<String[]> al = new ArrayList<String[]>();
        StringBuffer sb = new StringBuffer();
        
        int c = -1;
        while ((c = in.read()) != -1)
            if ((char)c != ' ' && (char)c != '\t' && (char)c != '\n' && (char)c != '\r')
                sb.append((char) c);

        String document = sb.toString().toLowerCase().trim();
        String[] note = new String[2];

        String sr = "<root>"; String er = "</root>";
        String sn = "<note>"; String en = "</note>";
        String st = "<tone>"; String et = "</tone>";
        String sd = "<dura>"; String ed = "</dura>";

        int begNote, endNote, begTone, endTone, begDura, endDura;

        do
        {   begNote = document.indexOf(sn); endNote = document.indexOf(en);
            begTone = document.indexOf(st); endTone = document.indexOf(et);
            begDura = document.indexOf(sd); endDura = document.indexOf(ed);
            
            if (begNote > -1)
            {   note[0] = document.substring(begTone+st.length(), endTone);
                note[1] = document.substring(begDura+sd.length(), endDura);
                al.add(note.clone());
                document = document.substring(endNote+en.length());
            }
        }   while(begNote > -1);

        in.close();
        return al;
    }

   private void compileReadRangeCommand(char s) 
   {    int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 'r';
        command[count++] = (byte)s;                                           //RANGE MODIFIER
        command[count++] = 'i';
        command[count++] = '0';
        command[count++] = 't'; command[count++] = command[count++] = '0';    //TIME MODIFIER
        command[count++] = 'd';
        //THE REST ARE NOT USED
        while (count < this.serial.getCommandLength()-1)
        {   command[count++] = 0;
        }
        command[count] = '\r';

        if (command.length == this.serial.getCommandLength())
            this.serial.writeOut(new String(command));
    }

    private byte[] getCommand (char c, char m, char i, char tu, char tl, String d)
    {   byte[] command = new byte[this.serial.getCommandLength()];

        //LOAD COMMAND CONSTANTS
        command[0] = (byte) c;
        command[1] = (byte) m;
        command[2] = 'i';
        command[3] = (byte) i;
        command[4] = 't';
        command[5] = (byte) tu;
        command[6] = (byte) tl;
        command[7] = 'd';

        //LOAD DATA, LONGER STRING WILL JUST DROP
        for (int n=8; n<command.length-1; ++n)
        {   if (n-8 > (d.length()-1))
                command[n] = 0;
            else
                command[n] = d.getBytes()[n-8];
        }

        //TERMINATE WITH CR
        command[this.serial.getCommandLength()-1] = '\r';

        return command;
    }

    private class ExtensionFileFilter extends FileFilter 
    {   String description;
        String extension;

        public ExtensionFileFilter() {
            this.description = this.extension = "";
        }

        public ExtensionFileFilter(String description) {
            this.description = this.extension = description.toLowerCase();
        }

        public ExtensionFileFilter(String description, String extension) {
            this.description = description.toLowerCase();
            this.extension = extension.toLowerCase();
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean accept(File file) {
            if (file.isDirectory() || this.extension.length() == 0)
                return true;
            else
            {   String path = file.getAbsolutePath().toLowerCase();
                if (path.endsWith(this.extension) && (path.charAt(path.length() - extension.length() - 1)) == '.')
                    return true;
            }
            return false;
        }
    }

    @Action
    public void selectedSerialPortMenuItem() 
    {   try
        {   Object[] options = HiveSerialComm.getPortListArray();
            String message = "Please, pick the serial port:";
            
            final JDialog dialog = new JDialog(new JFrame(), "Click a button", true);
            final JOptionPane optionPane = new JOptionPane (message, JOptionPane.PLAIN_MESSAGE, JOptionPane.OK_CANCEL_OPTION, null, options, options[0]);

            dialog.setContentPane(optionPane);
            dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);

            dialog.addWindowListener
            (   new WindowAdapter()
                {   @Override public void windowClosing(WindowEvent we) 
                    {
                    }
                }
            );

            optionPane.addPropertyChangeListener
            (   new PropertyChangeListener()
                {   public void propertyChange(PropertyChangeEvent e)
                    {   String prop = e.getPropertyName();
                        if (dialog.isVisible()&&(e.getSource()==optionPane)&&(prop.equals(JOptionPane.VALUE_PROPERTY)))
                        {   dialog.setVisible(false);
                        }
                    }
                }
            );

            dialog.pack();
            dialog.setVisible(true);

            this.portId = (String)optionPane.getValue();
            if(this.serial!=null)
            {   this.serial.close();
                this.serial = null;
                this.flagSerial = this.START;
                this.buttonSerialPort.setText("Connect");
                this.statusMessageLabel.setText("DISCONNECTED");
            }
            this.enableAll(this.STOP, this.buttonSerialPort);
        }
        catch (Throwable t) {t.printStackTrace();}

    }

    public JTextField getTextFieldInfraredRangeLeft() {
        return textFieldInfraredRangeLeft;
    }

    public JTextField getTextFieldInfraredRangeRight() {
        return textFieldInfraredRangeRight;
    }

    public JTextField getTextFieldLineRangeLeft() {
        return textFieldLineRangeLeft;
    }

    public JTextField getTextFieldLineRangeRight() {
        return textFieldLineRangeRight;
    }

    public JTextField getTextFieldSonarRange() {
        return textFieldSonarRange;
    }
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonClearScript;
    private javax.swing.JButton buttonLoadScript;
    private javax.swing.JButton buttonMoveBackward;
    private javax.swing.JButton buttonMoveForward;
    private javax.swing.JButton buttonRunScript;
    private javax.swing.JButton buttonSaveScript;
    private javax.swing.JButton buttonSerialPort;
    private javax.swing.JButton buttonSpeakerBuzz;
    private javax.swing.JButton buttonSpeakerBuzz1;
    private javax.swing.JButton buttonSpeakerClick;
    private javax.swing.JButton buttonSpeakerClick1;
    private javax.swing.JButton buttonSpeakerPlay;
    private javax.swing.JButton buttonSwitchCamera;
    private javax.swing.JButton buttonSwitchInfrared;
    private javax.swing.JButton buttonSwitchLine;
    private javax.swing.JButton buttonSwitchSonar;
    private javax.swing.JButton buttonTurnLeft;
    private javax.swing.JButton buttonTurnRight;
    private javax.swing.JLabel iconFaultLED;
    private javax.swing.JLabel iconInfraredLED;
    private javax.swing.JLabel iconStatusLED;
    private javax.swing.JLabel iconU1LED;
    private javax.swing.JLabel iconU2LED;
    private javax.swing.JLabel iconU3LED;
    private javax.swing.JLabel iconU4LED;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem menuItemLog;
    private javax.swing.JPanel panelColorSensorLine;
    private javax.swing.JPanel panelComAction;
    private javax.swing.JPanel panelDisplay;
    private javax.swing.JPanel panelMoveAction;
    private javax.swing.JPanel panelRangeSensorInfrared;
    private javax.swing.JPanel panelRangeSensorSonar;
    private javax.swing.JPanel panelScript;
    private javax.swing.JPanel panelSensorAction;
    private javax.swing.JPanel panelSensors;
    private javax.swing.JPanel panelSpeakerAction;
    private javax.swing.JPanel panelSpeakerAction1;
    private javax.swing.JPanel panelVisualSensorHistogram;
    private javax.swing.JPanel panelVisualSensorMotion;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JMenuItem serialPortMenuItem;
    private javax.swing.JMenu settingsMenu;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JTextField textDisplay1;
    private javax.swing.JTextField textDisplay2;
    private javax.swing.JTextField textFieldInfraredRangeLeft;
    private javax.swing.JTextField textFieldInfraredRangeRight;
    private javax.swing.JTextField textFieldLineRangeLeft;
    private javax.swing.JTextField textFieldLineRangeRight;
    private javax.swing.JTextField textFieldSonarRange;
    private javax.swing.JTextPane textPaneScript;
    // End of variables declaration//GEN-END:variables

    private ArrayList<JButton> buttons = new ArrayList<JButton>();

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
    private JDialog executionLog;

    //EXECUTION LOG STRING TO BE PASSED TO THE HIVELOGBOX
    private JTextArea log = new JTextArea();

    //SERIAL COM
    private HiveSerialComm serial;
    private String         portId;
    private Thread         serialThread;

    //SPEAKER
    private HiveSpeakerTones notePicker;

    private final boolean START = true;
    private final boolean STOP = false;

    private boolean flagBuzz = true;
    private boolean flagClick = true;
    private boolean flagSerial = true;
    private boolean flagForward = true;
    private boolean flagBackward = true;
    private boolean flagLeft = true;
    private boolean flagRight = true;
    private boolean flagInfrared = true;
    private boolean flagSonar = true;
    private boolean flagLine = true;

}


