/* AI.h
 * Created on: Apr 15, 2009
 * Author: Ian Roskam
 */

/*
 * This class controls player two's character movements.
 */
#ifndef AI_H_
#define AI_H_

class AI
{
public:
	AI(); //Constructor
	uint32 getKeysDown(){return keys_down;} //inline
	uint32 getKeysHeld(){return keys_held;} //inline
	uint32 getKeysUp(){return keys_up;} //inline
	~AI(); //Destructor
private:
	enum state{
		STANDING, ATTACKING, DEFENDING, BLOCKING, CLOSE, FAR
	};
	enum action{
		IDLE, FOWARD, REVERSE, JUMP, DUCK, BLOCK, HPUNCH, LPUNCH, HKICK, LKICK
	};
	uint32 keys;
	uint32 keys_down, keys_held, keys_up;
	unsigned int random;
	state currentState;
	void setCurrentState();
	void setKeys(action nextAction);
	void setKeysDown();
	void setKeysHeld();
	void setKeysUp();
	void decider(); //given a state decide what to do
};
#endif /* AI_H_ */
