/* About.cpp
 * Created on: Apr 20, 2009
 * Author: Ian Roskam
 */
#include <nds.h>

#include "About.h"

/**
 * Create a new background using the 'about' background.
 */
About::About()
{
	this->background = new Background(Background::ABOUT);
	this->done = false;
}
/**
 * Check if any keys are being pressed.  Only the 'B' button is used here.
 */
void About::handleInput()
{
	scanKeys();
	if(keysDown()&KEY_B)
		done = true;
}
/**
 * Start the loop that checks for input.
 * @return - will always return TITLE as the next game state
 */
gameState About::start()
{
	background->display();
	while(!done)
	{
		handleInput();
	}
	return TITLE;
}
/**
 * Free up the memory used by the background.
 */
About::~About()
{
	if(background!=NULL)
	{
		delete background;
		background = NULL;
	}
}
