/* Background.cpp
 * Created on: Mar 6, 2009
 * Author: Ian Roskam
 */

#include <nds.h>
#include <string>
#include <ctime> //used for time seed
#include <cstdlib> //used for rand

#include "Background.h"

/**
 * Take an image enumeration and load the proper image.
 * @param bgImage - the background to load
 */
Background::Background(bgImage image)
{
	this->backgroundSrc = NULL;
	this->backgroundPalette = NULL;
	this->bgPriority = 3; //set priority to lowest available, drawn first
	setImage(image);
}
/**
 * Spin for a random background image and set the image.
 */
void Background::random()
{
	srand(time(NULL));
	int random = rand()%7; //get random number no larger than 6
	//iprintf("\nrandom %d",random);
	bgImage image = (bgImage)random;
	setImage(image);
}
/**
 * Set the information for the given image.
 * @param bgImage - the background to load
 */
void Background::setImage(bgImage image)
{
	switch(image)
	{
		//iprintf("\nimage %d",(int)image);
		case AIRFORCE :
			this->backgroundSrc = airforceBitmap;
			this->backgroundSrcSize = airforceBitmapLen;
			this->backgroundPalette = airforcePal;
			this->backgroundPaletteSize = airforcePalLen;
			break;
		case BALCONY :
			this->backgroundSrc = balconyBitmap;
			this->backgroundSrcSize = balconyBitmapLen;
			this->backgroundPalette = balconyPal;
			this->backgroundPaletteSize = balconyPalLen;
			break;
		case BEACH :
			this->backgroundSrc = beachBitmap;
			this->backgroundSrcSize = beachBitmapLen;
			this->backgroundPalette = beachPal;
			this->backgroundPaletteSize = beachPalLen;
			break;
		case STATUE :
			this->backgroundSrc = statueBitmap;
			this->backgroundSrcSize = statueBitmapLen;
			this->backgroundPalette = statuePal;
			this->backgroundPaletteSize = statuePalLen;
			break;
		case STREET :
			this->backgroundSrc = streetBitmap;
			this->backgroundSrcSize = streetBitmapLen;
			this->backgroundPalette = streetPal;
			this->backgroundPaletteSize = streetPalLen;
			break;
		case TEMPLE :
			this->backgroundSrc = templeBitmap;
			this->backgroundSrcSize = templeBitmapLen;
			this->backgroundPalette = templePal;
			this->backgroundPaletteSize = templePalLen;
			break;
		case VEGAS :
			this->backgroundSrc = vegasBitmap;
			this->backgroundSrcSize = vegasBitmapLen;
			this->backgroundPalette = vegasPal;
			this->backgroundPaletteSize = vegasPalLen;
			break;
		case RANDOM :
			random();
			break;
		case TITLE :
			this->backgroundSrc = titleBitmap;
			this->backgroundSrcSize = titleBitmapLen;
			this->backgroundPalette = titlePal;
			this->backgroundPaletteSize = titlePalLen;
			break;
		case CHSELECT :
			this->backgroundSrc = chSelectBitmap;
			this->backgroundSrcSize = chSelectBitmapLen;
			this->backgroundPalette = chSelectPal;
			this->backgroundPaletteSize = chSelectPalLen;
			break;
		case HELP :
			oamDisable(&oamMain);
			this->backgroundSrc = helpBitmap;
			this->backgroundSrcSize = helpBitmapLen;
			this->backgroundPalette = helpPal;
			this->backgroundPaletteSize = helpPalLen;
			break;
		case ABOUT :
			oamDisable(&oamMain);
			this->backgroundSrc = aboutBitmap;
			this->backgroundSrcSize = aboutBitmapLen;
			this->backgroundPalette = aboutPal;
			this->backgroundPaletteSize = aboutPalLen;
			break;
		default :
			return;
	}
}
/**
 * Allocate memory for the background and set the priority to lowest setting(3).
 *
 * WARNING: This method will overwrite any background in VRAM at the base
 * address.
 */
void Background::initBackground()
{
	this->bgID = bgInit(LAYER, BgType_Bmp8, BgSize_B8_256x256, 0,0);
	bgSetPriority(bgID, bgPriority);
}
/**
 * Load the palette and tiled background into VRAM to display.
 */
void Background::display()
{
	initBackground();
	dmaCopy(backgroundPalette, BG_PALETTE, backgroundPaletteSize);
	dmaCopy(backgroundSrc, bgGetGfxPtr(bgID), backgroundSrcSize);
}

/**
 * Nothing is allocated with new so there is nothing to clean up.
 */
Background::~Background()
{
}
