/* Character.cpp
 * Created on: Mar 8, 2009
 * Author: Ian Roskam
 */

#include<nds.h>
#include <ctime>   //used for time seed
#include <cstdlib> //used for rand

#include "Character.h"

/**
 * The Character class constructor.  Calling this constructor will also
 * initilize the Sprite for this class.
 * @param character the enumerated character name
 * @param playerOne true for playerOne and false for playerTwo
 */
Character::Character(characters character , bool playerOne)
{

	this->blocking = false;
	this->playerOne = playerOne;
	this->idleLoaded = false;
	if(playerOne)
		ai = NULL;
	else
		ai = new AI();
	loadCharacter(character);
}
/**
 * Call a given characters load routine.
 * @param characters - the character to load
 */
void Character::loadCharacter(characters character)
{
	switch(character)
	{
		case AKUMA :
			loadAkuma();
			break;
		case CHUNLI :
			loadChunli();
			break;
		case KEN :
			loadKen();
			break;
		case MAKATO :
			loadMakato();
			break;
		case RYU :
			loadRyu();
			break;
		case SEAN :
			loadSean();
			break;
		case YANG :
			loadYang();
			break;
		case YUN :
			loadYun();
			break;
		case RANDOM :
			loadRandom();
			break;
		default :
			return; //should never get here
	}
	idleStance();
}
/**
 * Load the stats and sprites for Akuma.
 */
void Character::loadAkuma()
{
	this->name = "Akuma";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(akumaTiles, akumaTilesLen, akumaPal, akumaPalLen, 0,
				10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(akumaTiles, akumaTilesLen, akumaPal, akumaPalLen, 1,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
}
/**
 * Load the stats and sprites for Chunli.
 */
void Character::loadChunli()
{
	this->name = "Chun-Li";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(chunliTiles, chunliTilesLen, chunliPal, chunliPalLen,
				3, 10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(chunliTiles, chunliTilesLen, chunliPal, chunliPalLen,
				4, SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Load the stats and sprites for Ken.
 */
void Character::loadKen()
{
	this->name = "Ken";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(kenTiles, kenTilesLen, kenPal, kenPalLen, 3,
				10,	SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(kenTiles, kenTilesLen, kenPal, kenPalLen, 4,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Load the stats and sprites for Makato.
 */
void Character::loadMakato()
{
	this->name = "Makato";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(makatoTiles, makatoTilesLen, makatoPal, makatoPalLen,
				3, 10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(makatoTiles, makatoTilesLen, makatoPal, makatoPalLen,
				4, SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Load the stats and sprites for Ryu.
 */
void Character::loadRyu()
{
	this->name = "Ryu";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(ryuTiles, ryuTilesLen, ryuPal, ryuPalLen, 0,
				10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(ryuTiles, ryuTilesLen, ryuPal, ryuPalLen, 1,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}

}
/**
 * Load the stats and sprites for Sean.
 */
void Character::loadSean()
{
	this->name = "Sean";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(seanTiles, seanTilesLen, seanPal, seanPalLen, 3,
				10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(seanTiles, seanTilesLen, seanPal, seanPalLen, 4,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Load the stats and sprites for Yang.
 */
void Character::loadYang()
{
	this->name = "Yang";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(yangTiles, yangTilesLen, yangPal, yangPalLen, 3,
				10, SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(yangTiles, yangTilesLen, yangPal, yangPalLen, 4,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Load the stats and sprites for Yun.
 */
void Character::loadYun()
{
	this->name = "Yun";
	this->health = 10;
	this->power = 10;
	this->speed = 10;
	this->defense = 10;
	/*
	if(playerOne)
	{
		//for player one create a sprite starting at (10,118)
		this->sprite.init(yunTiles, yunTilesLen, yunPal, yunPalLen, 3,
				10,	SCREEN_HEIGHT-74, Sprite::RIGHT);
	}
	else
	{
		//for player two create a sprite starting at (182,118)
		this->sprite.init(yunTiles, yunTilesLen, yunPal, yunPalLen, 4,
				SCREEN_WIDTH-74, SCREEN_HEIGHT-74, Sprite::LEFT);
	}
	*/
}
/**
 * Spin for a random character.
 */
void Character::loadRandom()
{
	srand(time(NULL));
	int random = rand()%8; //get a random number less than 8
	loadCharacter((characters)random);
}
/**
 * Perform actions when a key is pressed.
 */
void Character::handleKeysDown(uint32 keys_down)
{
	if(keys_down>0)
		idleLoaded = false;
	if(keys_down&KEY_UP)
		jump();
	if(keys_down&KEY_RIGHT)
	{
		if(sprite.getDirection()==Sprite::RIGHT) //if facing right
			sprite.loadStrip(sprite.FOWARD);
		else
			sprite.loadStrip(sprite.REVERSE);
	}
	if(keys_down&KEY_DOWN)
		sprite.loadStrip(sprite.DUCK);
	if(keys_down&KEY_LEFT)
	{
		if(sprite.getDirection()==Sprite::RIGHT) //if facing right
			sprite.loadStrip(sprite.REVERSE);
		else
			sprite.loadStrip(sprite.FOWARD);
	}
	if(keys_down&KEY_A)
		highPunch();
	if(keys_down&KEY_B)
		lowPunch();
	if(keys_down&KEY_X)
		highKick();
	if(keys_down&KEY_Y)
		lowKick();
	if((keys_down&KEY_L)||(keys_down&KEY_R))
			block();
}
/**
 * Perform actions when a key is held down.
 */
void Character::handleKeysHeld(uint32 keys_held)
{
	if(keys_held&KEY_DOWN);
		//duck();
	if(keys_held&KEY_RIGHT)
	{
		if(sprite.getDirection()==Sprite::RIGHT) //if facing right
			foward();
		else
			reverse();
	}

	if(keys_held&KEY_LEFT)
	{
		if(sprite.getDirection()==Sprite::RIGHT) //if facing right
			reverse();
		else
			foward();
	}

}
/**
 * When a key is released go back to the idle stance.
 */
void Character::handleKeysUp(uint32 keys_up)
{
	if(keys_up>0&&!(keys_up&KEY_SELECT))
		idleStance();
}
/**
 * Checks what buttons are being pressed and calls the appropriate method.
 */
void Character::handleInput()
{
	uint32 keys_down;
	uint32 keys_held;
	uint32 keys_up;
	//uint16 special_keys = IPC->buttons;

	if(playerOne)
	{
		keys_down = keysDown();
		//keys_down |= special_keys;
		keys_held = keysHeld();
		keys_up = keysUp();
		//keys_up |= special_keys;
	}
	else
	{
		keys_down = ai->getKeysDown();
		keys_held = ai->getKeysHeld();
		keys_held = ai->getKeysUp();
	}

	if(keys_down==0&&keys_held==0)
		idleStance();
	else
	{
		handleKeysDown(keys_down);
		handleKeysHeld(keys_held);
		handleKeysUp(keys_up);
	}
}
/**
 * Cycles throught the current animation.
 */
void Character::display()
{
	sprite.nextFrame();
	sprite.animateSprite();
}
/**
 * Called by the FightEngine when character is hit.
 */
void Character::hit(int value)
{
	if(!blocking)
		health -= value;
	else
	{
		if(defense!=0)
			health -= (value/defense);
	}
}
/**
 * Load the idle stance animation strip.
 */
void Character::idleStance()
{
	//idle stance animation
	if(!idleLoaded)
	{
		//iprintf("\nidle stance loaded");
		sprite.loadStrip(sprite.STANCE);
		idleLoaded = true;
	}
}
//basic moves
/**
 * Changes the frameStrip to the jump animation and changes the 'y' coordinate
 * to emulate jumping.
 */
void Character::jump()
{
	//access jump position of sprite array
	//iprintf("\nJump loade");
	sprite.loadStrip(sprite.JUMP);
	for(int i=0; i<40; i++)
	{
		if(i<20)
			sprite.decrPosY(); //jump up 15 pixels
		else
			sprite.incrPosY(); //fall down 15 pixels
		swiWaitForVBlank();
	}
}
/**
 * Changes the frameStrip to the walk animation and changes the 'x' coordinate
 * to emulate movement.  If the character reaches a screen boundary no movement
 * occurs.
 */
void Character::foward()
{
	int posX = sprite.getPosX();
	if(!(posX<=-1||posX>=SCREEN_WIDTH+1))
		sprite.forward();
	if(posX<0)
		sprite.setPosX(0);
	if(posX > SCREEN_WIDTH)
		sprite.setPosX(SCREEN_WIDTH);
}
/**
 * changes the frameStrip to the walk animation and changes the 'x' coordinate
 * to emulate movement.  If the character reaches a screen boundary no movement
 * occurs.
 */
void Character::reverse()
{
	//access reverse of walking sprite array
	int posX = sprite.getPosX();
	if(!(posX<=-1||posX>=SCREEN_WIDTH+1))
		sprite.reverse();
	if(posX<0)
		sprite.setPosX(0);
	if(posX>SCREEN_WIDTH)
		sprite.setPosX(SCREEN_WIDTH);
	//iprintf("\n%d", sprite.posX);
}
/**
 * Changes the frameStrip to the duck animation.
 */
void Character::duck()
{
	//access duck image of sprite array
	//iprintf("\nDuck loaded");
	sprite.loadStrip(sprite.DUCK);
}
/**
 * Changes the frameStrip to the high punch animation.
 */
void Character::highPunch()
{
	//access high punch image of sprite array;
	//iprintf("\nHigh Punch loaded");
	sprite.loadStrip(sprite.HIGHPUNCH);
}
/**
 * Changes the frameStrip to the low punch animation.
 */
void Character::lowPunch()
{
	//access low punch image of sprite array
	//iprintf("\nLow Punch loaded");
	sprite.loadStrip(sprite.LOWPUNCH);
}
/**
 * Changes the frameStrip to the high kick animation.
 */
void Character::highKick()
{
	//access high kick image of sprite array
	//iprintf("\nHigh Kick loaded");
	sprite.loadStrip(sprite.HIGHKICK);
}
/**
 * Changes the frameStrip to the low kick animation.
 */
void Character::lowKick()
{
	//access low kick image of spriate array
	//iprintf("\nLow Kick loaded");
	sprite.loadStrip(sprite.LOWKICK);
}
/**
 * Changes the frameStrip to the block animation.
 */
void Character::block()
{
	//display block image
	//iprintf("\nBlock loaded");
	sprite.loadStrip(sprite.BLOCK);
}
/**
 * Toggles the blocking flag.
 */
void Character::toggleBlock()
{
	//access block image of sprite array
	if(!blocking)
		blocking = true;
	else blocking = false;
}
//end basic moves
/**
 * Calls the sprite deconstructor.
 */
Character::~Character()
{
	if(ai!=NULL)
	{
		delete ai;
		ai = NULL;
	}
}
