/* CharacterSelect.cpp
 * Created on: Mar 11, 2009
 * Author: Ian
 */

#include <nds.h>

#include "CharacterSelect.h"

/**
 * The CharacterSelect constructor. Sets the initial cursor position to one.
 */
CharacterSelect::CharacterSelect() //Constructor
{
	this->background = new Background(Background::CHSELECT);
	this->cursor = new Cursor(Cursor::BOX_32x32);
	this->playerOne = Character::AKUMA;
	this->playerTwo = Character::AKUMA;
	this->fightBg = Background::AIRFORCE;
	selectedCh = Character::AKUMA;
	selectedBg = Background::AIRFORCE;
	this->p1Selected = false;
	this->p2Selected = false;
	this->bgSelected = false;
	this->done = false;
	this->keys = 0;
	this->nextState = FIGHT;
	updateCursor();
}
/**
 * Move the cursor to the new position.
 */
void CharacterSelect::updateCursor()
{
	if(!(p1Selected && p2Selected))
	{
		switch(selectedCh)
		{
			case Character::AKUMA :
				cursor->move(80,32);
				break;
			case Character::CHUNLI :
				cursor->move(112,32);
				break;
			case Character::KEN :
				cursor->move(144,32);
				break;
			case Character::MAKATO :
				cursor->move(80,64);
				break;
			case Character::RYU :
				cursor->move(112,64);
				break;
			case Character::SEAN :
				cursor->move(144,64);
				break;
			case Character::YANG :
				cursor->move(80,96);
				break;
			case Character::YUN :
				cursor->move(112,96);
				break;
			case Character::RANDOM :
				cursor->move(144,96);
				break;
			default:
				return;
		}
	}
	else if(!bgSelected)
	{
		switch(selectedBg)
		{
			case Background::AIRFORCE :
				cursor->move(0,161);
				break;
			case Background::BALCONY :
				cursor->move(32,161);
				break;
			case Background::BEACH :
				cursor->move(64,161);
				break;
			case Background::STATUE :
				cursor->move(96,161);
				break;
			case Background::STREET :
				cursor->move(128,161);
				break;
			case Background::TEMPLE :
				cursor->move(160,161);
				break;
			case Background::VEGAS :
				cursor->move(192,161);
				break;
			case Background::RANDOM :
				cursor->move(224,161);
				break;
			default :
				return; //should never get here
		}
	}
}
/**
 * Instantiate playerOne with currently selected character and set p1Selected.
 */
void CharacterSelect::chooseP1()
{
	switch(selectedCh)
	{
		case Character::AKUMA :
			playerOne = Character::AKUMA;
			break;
		case Character::CHUNLI :
			playerOne = Character::CHUNLI;
			break;
		case Character::KEN :
			playerOne = Character::KEN;
			break;
		case Character::MAKATO :
			playerOne = Character::MAKATO;
			break;
		case Character::RYU :
			playerOne = Character::RYU;
			break;
		case Character::SEAN :
			playerOne = Character::SEAN;
			break;
		case Character::YANG :
			playerOne = Character::YANG;
			break;
		case Character::YUN :
			playerOne = Character::YUN;
			break;
		case Character::RANDOM :
			playerOne = Character::RANDOM;
			break;
		default :
			return; //should never get here
	}
	p1Selected = true;
}
/**
 * Set playerTwo with currently selected character and set p2Selected.
 */
void CharacterSelect::chooseP2()
{
	switch(selectedCh)
	{
		case Character::AKUMA :
			playerTwo = Character::AKUMA;
			break;
		case Character::CHUNLI :
			playerTwo = Character::CHUNLI;
			break;
		case Character::KEN :
			playerTwo = Character::KEN;
			break;
		case Character::MAKATO :
			playerTwo = Character::MAKATO;
			break;
		case Character::RYU :
			playerTwo = Character::RYU;
			break;
		case Character::SEAN :
			playerTwo = Character::SEAN;
			break;
		case Character::YANG :
			playerTwo = Character::YANG;
			break;
		case Character::YUN :
			playerTwo = Character::YUN;
			break;
		case Character::RANDOM :
			playerTwo = Character::RANDOM;
			break;
		default :
			return; //should never get here
	}
	p2Selected = true;
}
/**
 * Set background with currently selected background and set bgSelected.
 */
void CharacterSelect::chooseBg()
{
	switch(selectedBg)
	{
		case Background::AIRFORCE :
			fightBg = Background::AIRFORCE;
			break;
		case Background::BALCONY :
			fightBg = Background::BALCONY;
			break;
		case Background::BEACH :
			fightBg = Background::BEACH;
			break;
		case Background::STATUE :
			fightBg = Background::STATUE;
			break;
		case Background::STREET :
			fightBg = Background::STREET;
			break;
		case Background::TEMPLE :
			fightBg = Background::TEMPLE;
			break;
		case Background::VEGAS :
			fightBg = Background::VEGAS;
			break;
		case Background::RANDOM :
			fightBg = Background::RANDOM;
			break;
		default :
			return; //should never get here
	}
	bgSelected = true;
}
/**
 * Call the appropriate choose method according to what has already been
 * selected. Confirm when all selections have been made.
 */
void CharacterSelect::select()
{
	if(!p1Selected)
	{
		iprintf("\np1 selected");
		chooseP1();
	}
	else if(!p2Selected)
	{
		iprintf("\np2 selected");
		chooseP2();
	}
	else if(!bgSelected)
	{
		iprintf("\nbg selected");
		chooseBg();
	}
	else
	{
		//iprintf("\nstart engine");
		nextState = FIGHT;
		done = true;
	}
}
/**
 * Undo the most recent selection. If no selections have been made return to the
 * title screen.
 */
void CharacterSelect::back()
{
	if(bgSelected)
	{
		iprintf("deselect bg");
		fightBg = Background::AIRFORCE;
		bgSelected = false;
	}
	else if(p2Selected)
	{
		iprintf("deselect p2");
		playerTwo = Character::AKUMA;
		p2Selected = false;
	}
	else if(p1Selected)
	{
		iprintf("deselect p1");
		playerOne = Character::AKUMA;
		p1Selected = false;
	}
	else
	{
		//iprintf("return to title");
		this->done = true;
		nextState = TITLE;
	}
}
/**
 * Move the cursor up.
 */
void CharacterSelect::up()
{
	switch(selectedCh)
	{
		case Character::AKUMA :
			selectedCh = Character::YANG;
			break;
		case Character::CHUNLI :
			selectedCh = Character::YUN;
			break;
		case Character::KEN :
			selectedCh = Character::RANDOM;
			break;
		case Character::MAKATO :
			selectedCh = Character::AKUMA;
			break;
		case Character::RYU :
			selectedCh = Character::CHUNLI;
			break;
		case Character::SEAN :
			selectedCh = Character::KEN;
			break;
		case Character::YANG :
			selectedCh = Character::MAKATO;
			break;
		case Character::YUN :
			selectedCh = Character::RYU;
			break;
		case Character::RANDOM :
			selectedCh = Character::SEAN;
			break;
		default :
			return; //should never get here
	}
}
/**
 * Move the cursor right.
 */
void CharacterSelect::right()
{
	if(!(p1Selected && p2Selected))
	{
		switch(selectedCh)
		{
			case Character::AKUMA :
				selectedCh = Character::CHUNLI;
				break;
			case Character::CHUNLI :
				selectedCh = Character::KEN;
				break;
			case Character::KEN :
				selectedCh = Character::AKUMA;
				break;
			case Character::MAKATO :
				selectedCh = Character::RYU;
				break;
			case Character::RYU :
				selectedCh = Character::SEAN;
				break;
			case Character::SEAN :
				selectedCh = Character::MAKATO;
				break;
			case Character::YANG :
				selectedCh = Character::YUN;
				break;
			case Character::YUN :
				selectedCh = Character::RANDOM;
				break;
			case Character::RANDOM :
				selectedCh = Character::YANG;
				break;
			default :
				return; //should never get here
		}
	}
	else
	{
		switch(selectedBg)
		{
			case Background::AIRFORCE :
				selectedBg = Background::BALCONY;
				break;
			case Background::BALCONY :
				selectedBg = Background::BEACH;
				break;
			case Background::BEACH :
				selectedBg = Background::STATUE;
				break;
			case Background::STATUE :
				selectedBg = Background::STREET;
				break;
			case Background::STREET :
				selectedBg = Background::TEMPLE;
				break;
			case Background::TEMPLE :
				selectedBg = Background::VEGAS;
				break;
			case Background::VEGAS :
				selectedBg = Background::RANDOM;
				break;
			case Background::RANDOM :
				selectedBg = Background::AIRFORCE;
				break;
			default :
				return; //should never get here
		}
	}
}
/**
 * Move the cursor down.
 */
void CharacterSelect::down()
{
	switch(selectedCh)
	{
		case Character::AKUMA :
			selectedCh = Character::MAKATO;
			break;
		case Character::CHUNLI :
			selectedCh = Character::RYU;
			break;
		case Character::KEN :
			selectedCh = Character::SEAN;
			break;
		case Character::MAKATO :
			selectedCh = Character::YANG;
			break;
		case Character::RYU :
			selectedCh = Character::YUN;
			break;
		case Character::SEAN :
			selectedCh = Character::RANDOM;
			break;
		case Character::YANG :
			selectedCh = Character::AKUMA;
			break;
		case Character::YUN :
			selectedCh = Character::CHUNLI;
			break;
		case Character::RANDOM :
			selectedCh = Character::KEN;
			break;
		default :
			return; //should never get here
	}
}
/**
 * Move the cursor left.
 */
void CharacterSelect::left()
{
	if(!(p1Selected && p2Selected))
	{
		switch(selectedCh)
		{
			case Character::AKUMA :
				selectedCh = Character::KEN;
				break;
			case Character::CHUNLI :
				selectedCh = Character::AKUMA;
				break;
			case Character::KEN :
				selectedCh = Character::CHUNLI;
				break;
			case Character::MAKATO :
				selectedCh = Character::SEAN;
				break;
			case Character::RYU :
				selectedCh = Character::MAKATO;
				break;
			case Character::SEAN :
				selectedCh = Character::RYU;
				break;
			case Character::YANG :
				selectedCh = Character::RANDOM;
				break;
			case Character::YUN :
				selectedCh = Character::YANG;
				break;
			case Character::RANDOM :
				selectedCh = Character::YUN;
				break;
			default :
				return; //should never get here
		}
	}
	else
	{
		switch(selectedBg)
		{
			case Background::AIRFORCE :
				selectedBg = Background::RANDOM;
				break;
			case Background::BALCONY :
				selectedBg = Background::AIRFORCE;
				break;
			case Background::BEACH :
				selectedBg = Background::BALCONY;
				break;
			case Background::STATUE :
				selectedBg = Background::BEACH;
				break;
			case Background::STREET :
				selectedBg = Background::STATUE;
				break;
			case Background::TEMPLE :
				selectedBg = Background::STREET;
				break;
			case Background::VEGAS :
				selectedBg = Background::TEMPLE;
				break;
			case Background::RANDOM :
				selectedBg = Background::VEGAS;
				break;
			default :
				return; //should never get here
		}
	}
}
/**
 * Checks what buttons are being pressed and updates the cursor position
 * accordingly.
 */
void CharacterSelect::handleInput()
{
	scanKeys();
	keys = keysDown();
	if(keys & KEY_UP)
	{
		up();
		updateCursor();
	}
	if(keys & KEY_RIGHT)
	{
		right();
		updateCursor();
	}
	if(keys & KEY_DOWN)
	{
		down();
		updateCursor();
	}
	if(keys & KEY_LEFT)
	{
		left();
		updateCursor();
	}
	if(keys & KEY_A)
	{
		select();
		updateCursor();
	}
	if(keys & KEY_B)
	{
		back();
		updateCursor();
	}
}

/**
 * Actions to perform during a VBlank.
 */
void CharacterSelect::vBlank()
{
	oamUpdate(&oamMain);
}

/**
 * Call this method to begin the CharacterSelect loop.
 */
gameState CharacterSelect::start()
{
	background->display();
	while(!done)
	{
		handleInput();
		swiWaitForVBlank();
	}
	return nextState;
}
/**
 * The CharacterSelect deconstructor
 */
CharacterSelect::~CharacterSelect() //Destructor
{
	if(cursor!=NULL)
	{
		delete cursor;
		cursor = NULL;
	}
	if(background!=NULL)
	{
		delete background;
		background = NULL;
	}
}
