/* CharacterSelect.h
 * Created on: Mar 11, 2009
 * Author: Ian
 */

/**
 * The character select screen allows a player to choose their character,
 * opponent, and fight background.
 */

#ifndef CHARACTERSELECT_H_
#define CHARACTERSELECT_H_

#include "Background.h"
#include "Character.h"
#include "Cursor.h"
#include "FightEngine.h"
#include "gameState.h"

class CharacterSelect {
public:
	CharacterSelect(); //Constructor
	gameState start();
	void vBlank();
	Character::characters getP1(){return playerOne;} //inline
	Character::characters getP2(){return playerTwo;} //inline
	Background::bgImage getFightBg(){return fightBg;} //inline
	~CharacterSelect(); //Destructor
private:
	Character::characters selectedCh; //the currently selected character
	Character::characters playerOne; //player one character
	Character::characters playerTwo; //player two character
	Background::bgImage selectedBg; //the currently selected background
	Background::bgImage fightBg; //the background to load for fight engine
	Cursor* cursor;
	Background* background;
	bool p1Selected, p2Selected, bgSelected; //selected flags
	bool done;
	int keys;
	gameState nextState;
	void updateCursor();
	void chooseP1(); //set playerOne with selectedCh
	void chooseP2(); //set playerTwo with selectedCh
	void chooseBg(); //set background with selectedBg
	void select();
	void back(); //back out of current selection
	void up(); //move cursor up
	void right(); //move cursor right
	void down(); //move cursor down
	void left(); //move cursor left
	void handleInput(); //respond to button presses
};
#endif /* CHARACTERSELECT_H_ */
