/* FightEngine.h
 * Created on: Mar 9, 2009
 * Author: Ian Roskam
 */

/**
 * The fight engine is the heart of the game.  Two characters fight each other
 * trying to be the first to deplete their opponent's health.  The engine
 * requires a background and two characters.
 */

#ifndef FIGHTENGINE_H_
#define FIGHTENGINE_H_

#include "Character.h"
#include "Background.h"
#include "HealthDisplay.h"
#include "gameState.h"

class FightEngine{
public:
	FightEngine(Character::characters playerOne,
			    Character::characters playerTwo,
			    Background::bgImage fightBg);
	gameState start();
	void vBlank();
	~FightEngine();
private:
	Background* background;
	Character* playerOne;
	Character* playerTwo;
	HealthDisplay* healthDisplay;
	gameState nextState;
	short int gravity;
	bool done, paused;
	unsigned short int p1Wins, p2Wins, maxWins;
	short int keys;
	void display();
	void handleInput();
	void togglePause();
	void displayWin();
	void displayLose();
	bool gameOver();
	//bool detectCollision(sprite* object1, sprite* object2);
};
#endif /* FIGHTENGINE_H_ */
