/* HealthDisplay.cpp
 * Created on: Apr 18, 2009
 * Author: Ian
 */
#include <nds.h>

#include "HealthDisplay.h"
#include <string> // only used for prints

HealthDisplay::HealthDisplay()
{
	this->tokenStartX = 11;
	this->tokenY = 26;
	this->tokenSize = 10;
	this->yellow = RGB15(0,31,31);
	this->black = RGB15(0,0,0);
	this->blue = RGB15(0,0,31);
	initToken();
}
void HealthDisplay::initToken()
{
	bool temp[100] =  {0,0,0,0,0,0,0,0,0,0,
					   0,0,0,0,1,1,0,0,0,0,
				       0,0,0,1,1,1,1,0,0,0,
			   	       0,0,1,1,1,1,1,1,0,0,
					   0,1,1,1,1,1,1,1,1,0,
					   0,1,1,1,1,1,1,1,1,0,
					   0,0,1,1,1,1,1,1,0,0,
					   0,0,0,1,1,1,1,0,0,0,
					   0,0,0,0,1,1,0,0,0,0,
					   0,0,0,0,0,0,0,0,0,0};
	this->token = temp;
}
void HealthDisplay::drawToken(bool playerOne, unsigned short int tokenNumber)
{
	if(tokenNumber<=0)
		return; //not a valid token number
	videoSetMode(MODE_FB1); //change to framebuffer mode

	unsigned short int startX = tokenStartX + (tokenSize * (tokenNumber-1));
	unsigned short int* buffer = VRAM_D + startX + (SCREEN_WIDTH * tokenY);
	if(playerOne)
	{
		for(int i=0; i<tokenSize; i++)
		{
			unsigned short int* line = buffer + (SCREEN_WIDTH * i);
			for(int j=0; j<tokenSize; j++)
			{
				if(token[(i*tokenSize)+j])
					*line++ = yellow;
			}
		}
	}
	else
	{
		startX = SCREEN_WIDTH - startX;
		buffer = VRAM_D + startX + (SCREEN_WIDTH * tokenY);
		for(int i=0; i<tokenSize; i++)
		{
			unsigned short int* line = buffer + (SCREEN_WIDTH * i);
			for(int j=0; j<tokenSize; j++)
			{
				if(token[(i*tokenSize)+j])
					*line++ = yellow;
			}
		}
	}
	//change back to mode 5
	videoSetMode(MODE_5_2D | DISPLAY_SPR_ACTIVE | DISPLAY_BG2_ACTIVE);
}
HealthDisplay::~HealthDisplay()
{
	// TODO Auto-generated destructor stub
}
