/* HealthDisplay.h
 * Created on: Apr 18, 2009
 * Author: Ian
 */

#ifndef HEALTHDISPLAY_H_
#define HEALTHDISPLAY_H_

/**
 * Use frame buffer mode to draw health display in the fight engine.  Health
 * display include character names, timer, and win tokens.
 */
class HealthDisplay
{
public:
	HealthDisplay();
	void drawToken(bool playerOne, unsigned short int tokenNumber);
	~HealthDisplay();
private:
	unsigned short int tokenStartX;
	unsigned short int tokenY;
	unsigned short int tokenSize;
	short int yellow;
	short int black;
	short int blue;
	bool *token;
	const char *p1Name, *p2Name;
	short int p1MaxHealth, p2MaxHealth;
	short int timer;
	short int p1Wins;
	short int p2Wins;
	void initToken();
};

#endif /* HEALTHDISPLAY_H_ */
