/* Title.cpp
 * Created on: Mar 6, 2009
 * Author: Ian
 */
#include <nds.h>

#include "Title.h"

/**
 * Create a new title screen with an arrow cursor.
 */
Title::Title()//Constructor
{
	background = new Background(Background::TITLE);
	cursor = new Cursor(Cursor::ARROW_8x8);
	this->selected = fight;
	this->done = false;
	this->nextState = CS;
	updateCursor();
}
/**
 * Move the cursor down.
 */
void Title::down()
{
	switch(selected)
	{
		case fight :
			selected = help;
			updateCursor();
			break;
		case help :
			selected = about;
			updateCursor();
			break;
		case about :
			selected = fight;
			updateCursor();
			break;
		default :
			return;
	}
}
/**
 * Move the cursor up.
 */
void Title::up()
{
	switch(selected)
	{
		case fight :
			selected = about;
			updateCursor();
			break;
		case help :
			selected = fight;
			updateCursor();
			break;
		case about :
			selected = help;
			updateCursor();
			break;
		default :
			return;
	}
}
/**
 * Select the next game state and break the loop.
 */
void Title::select()
{
	switch(selected)
	{
		case fight :
		{
			nextState = CS;
			done = true;
			break;
		}
		case help :
			nextState = HELP;
			done = true;
			break;
		case about :
			nextState = ABOUT;
			done = true;
			break;
		default :
			return;
	}
}
/**
 * More the cursor to a new location.
 */
void Title::updateCursor()
{
	switch(selected)
	{
		case fight :
			cursor->move(94,95);
			break;
		case help :
			cursor->move(94,113);
			break;
		case about :
			cursor->move(94,131);
			break;
		default :
			return;
	}
}
/**
 * Actions to perform when keys are pressed.
 */
void Title::handleInput()
{
	scanKeys();
	keys = keysDown();
	if(keys&KEY_DOWN)
		down();
	if(keys&KEY_UP)
		up();
	if(keys&KEY_A)
		select();
}
/**
 * Actions to perform during a VBlank.
 */
void Title::vBlank()
{
	this->updateCursor();
	oamUpdate(&oamMain);
}
/**
 * Start a loop.
 * @return gameState - the next game state
 */
gameState Title::start()
{
	//consoleDemoInit();
	background->display();
	while(!done)
	{
		handleInput();
		swiWaitForVBlank();
	}
	return nextState;
}
/**
 * Clean up memory before leaving.
 */
Title::~Title()//Destructor
{
	if(cursor!=NULL)
	{
		delete cursor;
		cursor = NULL;
	}
	if(background!=NULL)
	{
		delete background;
		background = NULL;
	}
}
