/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Tile;
import jCarcassonne.TileFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Farm
extends TileFeature {
    private ArrayList<Integer> cityNeighborColorCodes = new ArrayList();
    private ArrayList<TileFeature> cityNeighbors = null;

    protected Farm(int maxNeighbors, int tokenX, int tokenY, Tile tile, int colorCode, int ... cityColorCodes) {
        super(TileFeature.FeatureEnum.farm, maxNeighbors, tokenX, tokenY, tile, colorCode);
        int[] nArray = cityColorCodes;
        int n = cityColorCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int cityColorCode = nArray[n2];
            this.cityNeighborColorCodes.add(cityColorCode);
            ++n2;
        }
    }

    @Override
    protected boolean isComplete() {
        return false;
    }

    protected boolean hasCityNeighbors() {
        return !this.cityNeighborColorCodes.isEmpty();
    }

    protected Iterator<TileFeature> getCityNeighborIterator() {
        if (this.cityNeighbors == null) {
            this.cityNeighbors = new ArrayList();
            for (int colorCode : this.cityNeighborColorCodes) {
                this.cityNeighbors.add(this.tile.getFeatureByColorCode(colorCode));
            }
        }
        return this.cityNeighbors.iterator();
    }

    protected HashSet<TileFeature> getCityNeighborsInGroup() {
        HashSet<TileFeature> farmFeatureGroup = this.getFeaturesInGroup();
        HashSet<TileFeature> cityNeighborsInGroup = new HashSet<TileFeature>();
        for (TileFeature feature : farmFeatureGroup) {
            Farm farmFeature = (Farm)feature;
            Iterator<TileFeature> cityNeighborIterator = farmFeature.getCityNeighborIterator();
            while (cityNeighborIterator.hasNext()) {
                cityNeighborsInGroup.add(cityNeighborIterator.next());
            }
        }
        return cityNeighborsInGroup;
    }
}

