/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Tile;
import jCarcassonne.TileFeature;
import java.util.Iterator;

public class Road
extends TileFeature {
    protected Road(int maxNeighbors, int tokenX, int tokenY, Tile tile, int colorCode) {
        super(TileFeature.FeatureEnum.road, maxNeighbors, tokenX, tokenY, tile, colorCode);
    }

    protected boolean isEndPoint() {
        return this.getMaxNeighbors() == 1;
    }

    @Override
    protected boolean isComplete() {
        boolean firstHasEndPoint = false;
        boolean secondHasEndPoint = false;
        int numNeighbors = this.getNumNeighbors();
        if (this.isEndPoint() && numNeighbors == 1) {
            firstHasEndPoint = true;
            Iterator<TileFeature> neighborsIterator = this.getNeighborIterator();
            secondHasEndPoint = this.hasEndPoint(this, neighborsIterator.next());
        } else if (!this.isEndPoint() && numNeighbors == 2) {
            Iterator<TileFeature> neighborsIterator = this.getNeighborIterator();
            firstHasEndPoint = this.hasEndPoint(this, neighborsIterator.next());
            secondHasEndPoint = this.hasEndPoint(this, neighborsIterator.next());
        }
        return firstHasEndPoint && secondHasEndPoint;
    }

    private boolean hasEndPoint(TileFeature featureFrom, TileFeature featureTo) {
        if (((Road)featureTo).isEndPoint()) {
            return true;
        }
        Iterator<TileFeature> neighborIterator = featureTo.getNeighborIterator();
        while (neighborIterator.hasNext()) {
            TileFeature neighbor = neighborIterator.next();
            if (neighbor == featureFrom) continue;
            return this.hasEndPoint(featureTo, neighbor);
        }
        return false;
    }
}

