/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.TileFeature;
import jCarcassonne.Token;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;

public class Tile {
    protected final String name;
    private BufferedImage img;
    private BufferedImage imgFeatureMap;
    private int tileWidth;
    private int tileHeight;
    private int x = Integer.MAX_VALUE;
    private int y = Integer.MAX_VALUE;
    private boolean isPlaced = false;
    private TileFeature[] tileBorders = new TileFeature[13];
    private HashMap<Integer, TileFeature> tileFeatureHash = new HashMap();
    private Tile northTile = null;
    private Tile southTile = null;
    private Tile eastTile = null;
    private Tile westTile = null;
    protected static final int NNW = 0;
    protected static final int NORTH = 1;
    protected static final int NNE = 2;
    protected static final int ENE = 3;
    protected static final int EAST = 4;
    protected static final int ESE = 5;
    protected static final int SSE = 6;
    protected static final int SOUTH = 7;
    protected static final int SSW = 8;
    protected static final int WSW = 9;
    protected static final int WEST = 10;
    protected static final int WNW = 11;
    protected static final int CENTER = 12;

    protected Tile(BufferedImage img, BufferedImage imgFeatureMap, String name) {
        this.img = img;
        this.imgFeatureMap = imgFeatureMap;
        this.name = name;
        this.tileWidth = img.getWidth();
        this.tileHeight = img.getHeight();
    }

    protected void rotate() {
        if (this.isPlaced) {
            return;
        }
        TileFeature wswFeature = this.tileBorders[9];
        TileFeature westFeature = this.tileBorders[10];
        TileFeature wnwFeature = this.tileBorders[11];
        int i = 11;
        while (i >= 3) {
            this.tileBorders[i] = this.tileBorders[i - 3];
            --i;
        }
        this.tileBorders[2] = wnwFeature;
        this.tileBorders[1] = westFeature;
        this.tileBorders[0] = wswFeature;
        AffineTransform at = new AffineTransform();
        at.translate(this.tileWidth / 2, this.tileHeight / 2);
        at.rotate(Math.toRadians(90.0));
        at.translate(-this.tileWidth / 2, -this.tileHeight / 2);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        this.img = bio.filter(this.img, null);
        this.imgFeatureMap = bio.filter(this.imgFeatureMap, null);
        for (TileFeature feature : this.tileFeatureHash.values()) {
            Point2D tokenCoordinates = feature.getTokenCoordinates();
            tokenCoordinates = at.transform(tokenCoordinates, null);
            feature.setTokenCoordinates((int)tokenCoordinates.getX(), (int)tokenCoordinates.getY());
        }
    }

    protected void addFeature(TileFeature f, int b) {
        this.tileBorders[b] = f;
        this.tileFeatureHash.put(f.getColorCode(), f);
    }

    protected TileFeature getFeatureAtBorder(int directionalConstant) {
        return this.tileBorders[directionalConstant];
    }

    protected TileFeature getFeatureAt(int xInTile, int yInTile) {
        try {
            int rgb = this.imgFeatureMap.getRGB(xInTile, yInTile) - -16777216;
            return this.tileFeatureHash.get(rgb);
        }
        catch (Exception e) {
            System.out.println("TileFeature.getFeatureAt(): Error: tried to get feature at " + xInTile + " " + yInTile);
            System.out.println(e);
            return null;
        }
    }

    protected TileFeature getFeatureByColorCode(int colorCode) {
        return this.tileFeatureHash.get(colorCode);
    }

    protected Iterator<TileFeature> getFeatureIterator() {
        return this.tileFeatureHash.values().iterator();
    }

    protected void setNorthTile(Tile northTile) {
        this.northTile = northTile;
        TileFeature sswFeature = northTile.getFeatureAtBorder(8);
        TileFeature southFeature = northTile.getFeatureAtBorder(7);
        TileFeature sseFeature = northTile.getFeatureAtBorder(6);
        this.tileBorders[0].addNeighbor(sswFeature);
        this.tileBorders[1].addNeighbor(southFeature);
        this.tileBorders[2].addNeighbor(sseFeature);
    }

    protected void setSouthTile(Tile southTile) {
        this.southTile = southTile;
        TileFeature nnwFeature = southTile.getFeatureAtBorder(0);
        TileFeature northFeature = southTile.getFeatureAtBorder(1);
        TileFeature nneFeature = southTile.getFeatureAtBorder(2);
        this.tileBorders[8].addNeighbor(nnwFeature);
        this.tileBorders[7].addNeighbor(northFeature);
        this.tileBorders[6].addNeighbor(nneFeature);
    }

    protected void setEastTile(Tile eastTile) {
        this.eastTile = eastTile;
        TileFeature wnwFeature = eastTile.getFeatureAtBorder(11);
        TileFeature westFeature = eastTile.getFeatureAtBorder(10);
        TileFeature wswFeature = eastTile.getFeatureAtBorder(9);
        this.tileBorders[3].addNeighbor(wnwFeature);
        this.tileBorders[4].addNeighbor(westFeature);
        this.tileBorders[5].addNeighbor(wswFeature);
    }

    protected void setWestTile(Tile westTile) {
        this.westTile = westTile;
        TileFeature eneFeature = westTile.getFeatureAtBorder(3);
        TileFeature eastFeature = westTile.getFeatureAtBorder(4);
        TileFeature eseFeature = westTile.getFeatureAtBorder(5);
        this.tileBorders[11].addNeighbor(eneFeature);
        this.tileBorders[10].addNeighbor(eastFeature);
        this.tileBorders[9].addNeighbor(eseFeature);
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    protected void setPoint(Point p) {
        if (this.isPlaced) {
            return;
        }
        this.x = p.x;
        this.y = p.y;
    }

    protected void setXY(int x, int y) {
        if (this.isPlaced) {
            return;
        }
        this.x = x;
        this.y = y;
    }

    protected void placeToken(Token token, int xInTile, int yInTile) {
        TileFeature featureClicked = this.getFeatureAt(xInTile, yInTile);
        featureClicked.placeToken(token);
        token.setFeature(featureClicked);
    }

    protected void setPlaced(boolean isPlaced) {
        this.isPlaced = isPlaced;
    }

    protected boolean isPlaced() {
        return this.isPlaced;
    }

    public boolean hasToken() {
        for (TileFeature feature : this.tileFeatureHash.values()) {
            if (!feature.hasToken()) continue;
            return true;
        }
        return false;
    }

    public Token getToken() {
        for (TileFeature feature : this.tileFeatureHash.values()) {
            if (!feature.hasToken()) continue;
            return feature.getToken();
        }
        return null;
    }

    public Point getTokenCoordinates() {
        for (TileFeature feature : this.tileFeatureHash.values()) {
            if (!feature.hasToken()) continue;
            return feature.getTokenCoordinates();
        }
        return null;
    }

    protected String verifyFeatures() {
        String err = "";
        int i = 0;
        while (i < this.tileBorders.length - 1) {
            if (this.tileBorders[i] == null) {
                err = String.valueOf(err) + "Error: " + this.name + " - null tileFeature at " + i + "\n";
            }
            ++i;
        }
        return err.equals("") ? null : err;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public String toString() {
        String s = "";
        TileFeature[] tileFeatureArray = this.tileBorders;
        int n = this.tileBorders.length;
        int n2 = 0;
        while (n2 < n) {
            TileFeature f = tileFeatureArray[n2];
            if (f != null) {
                s = String.valueOf(s) + f.toString() + " ";
            }
            ++n2;
        }
        return String.valueOf(this.name) + " " + this.x + " " + this.y + " : " + s;
    }

    protected Tile getNorthTile() {
        return this.northTile;
    }

    protected Tile getSouthTile() {
        return this.southTile;
    }

    protected Tile getEastTile() {
        return this.eastTile;
    }

    protected Tile getWestTile() {
        return this.westTile;
    }
}

