/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonneGUI;

import jCarcassonne.GameController;
import jCarcassonne.Player;
import jCarcassonne.Tile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFrame;

public class JCarcassonne
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private int screenWidth;
    private int screenHeight;
    private final int tileWidth = 128;
    private final int tileHeight = 128;
    private Thread animator;
    private volatile boolean running = false;
    private Graphics2D dbg;
    private Image dbImage = null;
    private int transX = 0;
    private int transY = 0;
    private boolean northScrollFlag = false;
    private boolean southScrollFlag = false;
    private boolean eastScrollFlag = false;
    private boolean westScrollFlag = false;
    private Rectangle peekRectangle = new Rectangle(128, 128);
    private Rectangle doneButtonRectangle;
    private Rectangle endGameButtonRectangle;
    private boolean showScores = false;
    private String newPlayerName = new String();
    private ArrayList<Color> colorList = new ArrayList();
    private Iterator<Color> colorIterator;
    private GameController gameController;

    public static void main(String[] args) {
        new JCarcassonne();
    }

    public JCarcassonne() {
        super("JCarcassonne");
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(screenDim);
        this.screenWidth = screenDim.width;
        this.screenHeight = screenDim.height;
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.requestFocus();
        this.setUndecorated(true);
        this.setIgnoreRepaint(true);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
        this.doneButtonRectangle = new Rectangle(this.screenWidth - 64 + 10, this.screenHeight - 256 - 20, 40, 40);
        this.endGameButtonRectangle = new Rectangle(this.screenWidth - 64 + 10, this.screenHeight - 256 + 30, 40, 40);
        this.readyForTermination();
        this.addInputListeners();
        this.colorList.add(Color.red);
        this.colorList.add(Color.blue);
        this.colorList.add(Color.green);
        this.colorList.add(Color.white);
        this.colorList.add(Color.yellow);
        this.colorIterator = this.colorList.iterator();
        this.gameController = new GameController();
        this.startGame();
    }

    private void startGame() {
        if (this.animator == null || !this.running) {
            this.animator = new Thread(this);
            this.animator.start();
        }
    }

    public void stopGame() {
        this.running = false;
    }

    private void addInputListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JCarcassonne.this.handleMousePress(e.getX(), e.getY(), e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JCarcassonne.this.handleMouseMove(e.getX(), e.getY());
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JCarcassonne.this.running = false;
                } else if (e.getKeyCode() == 9) {
                    JCarcassonne.this.showScores = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    JCarcassonne.this.showScores = false;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (JCarcassonne.this.gameController.isGameStarting() && JCarcassonne.this.colorIterator.hasNext()) {
                    if (e.getKeyChar() == '\n' && !JCarcassonne.this.newPlayerName.isEmpty()) {
                        JCarcassonne.this.gameController.addPlayer(JCarcassonne.this.newPlayerName, (Color)JCarcassonne.this.colorIterator.next());
                        JCarcassonne.this.newPlayerName = new String();
                    } else if (e.getKeyChar() == '\b' && !JCarcassonne.this.newPlayerName.isEmpty()) {
                        JCarcassonne.this.newPlayerName = JCarcassonne.this.newPlayerName.substring(0, JCarcassonne.this.newPlayerName.length() - 1);
                    } else {
                        JCarcassonne jCarcassonne = JCarcassonne.this;
                        jCarcassonne.newPlayerName = String.valueOf(jCarcassonne.newPlayerName) + e.getKeyChar();
                    }
                }
            }
        });
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.gameRender();
            this.paintScreen();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
        System.exit(0);
    }

    private void gameRender() {
        if (this.dbImage == null) {
            this.dbImage = this.createImage(this.screenWidth, this.screenHeight);
            if (this.dbImage == null) {
                System.out.println("dbImage is null");
                return;
            }
            this.dbg = (Graphics2D)this.dbImage.getGraphics();
        }
        this.dbg.setColor(Color.white);
        this.dbg.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.hasFocus() && !this.gameController.isGameStarting()) {
            if (this.northScrollFlag) {
                this.transY += 4;
            }
            if (this.southScrollFlag) {
                this.transY -= 4;
            }
            if (this.eastScrollFlag) {
                this.transX -= 4;
            }
            if (this.westScrollFlag) {
                this.transX += 4;
            }
        }
        if (!this.gameController.isGameStarting()) {
            this.paintLandscape(this.dbg);
        }
        this.paintHUDbackground();
        if (!this.gameController.isGameStarting() && !this.gameController.isGameOver()) {
            this.paintHUD();
        }
        if (this.gameController.isGameStarting()) {
            this.displayStartScreen();
        }
        if (this.showScores && !this.gameController.isGameOver() && !this.gameController.isGameStarting()) {
            this.displayScores();
        }
        if (this.gameController.isGameOver()) {
            this.displayGameOverScreen();
        }
    }

    private void paintScreen() {
        try {
            Graphics g = this.getGraphics();
            if (g != null && this.dbImage != null) {
                g.drawImage(this.dbImage, 0, 0, null);
            }
            Toolkit.getDefaultToolkit().sync();
            g.dispose();
        }
        catch (Exception e) {
            System.out.println("Error painting screen: \n " + e);
        }
    }

    private void paintHUDbackground() {
        this.dbg.setColor(Color.DARK_GRAY);
        this.dbg.fillRect(this.screenWidth - 64, 0, this.screenWidth, this.screenHeight);
        this.dbg.fillRect(0, 0, this.screenWidth, 64);
    }

    private void paintHUD() {
        this.dbg.setColor(Color.LIGHT_GRAY);
        this.dbg.fill(this.doneButtonRectangle);
        this.dbg.setColor(Color.black);
        this.dbg.setFont(new Font("Serif", 1, 14));
        this.dbg.drawString("Done", this.doneButtonRectangle.x + 5, this.doneButtonRectangle.y + 25);
        this.dbg.setColor(Color.LIGHT_GRAY);
        this.dbg.fill(this.endGameButtonRectangle);
        this.dbg.setColor(Color.black);
        this.dbg.setFont(new Font("Serif", 1, 14));
        this.dbg.drawString("End", this.endGameButtonRectangle.x + 5, this.endGameButtonRectangle.y + 15);
        this.dbg.drawString("Game", this.endGameButtonRectangle.x + 3, this.endGameButtonRectangle.y + 30);
        this.dbg.translate(this.screenWidth - 128 + 2, this.screenHeight - 128 + 2);
        this.dbg.setColor(Color.black);
        this.dbg.setStroke(new BasicStroke(4.0f));
        this.dbg.draw(this.peekRectangle);
        BufferedImage img = this.gameController.getNextTileImage();
        if (img != null) {
            this.dbg.drawImage((Image)img, 0, 0, null);
        } else {
            this.dbg.fill(this.peekRectangle);
        }
        this.dbg.translate(-(this.screenWidth - 128 + 2), -(this.screenHeight - 128 + 2));
        this.dbg.setPaint(this.gameController.getCurrentPlayerColor());
        this.dbg.setFont(new Font("SansSerif", 1, 18));
        this.dbg.drawString(this.gameController.getCurrentPlayerName(), this.screenWidth / 3, 30);
        this.dbg.translate(this.screenWidth - 64 + 20, 20);
        this.dbg.setPaint(this.gameController.getCurrentPlayerColor());
        int tokenCount = this.gameController.getCurrentPlayerTokenCount();
        int tokenOffset = (this.screenHeight - 256 - 40) / 8;
        int i = 0;
        while (i < tokenCount) {
            this.dbg.fillOval(0, i * tokenOffset, 30, 30);
            ++i;
        }
        this.dbg.translate(-(this.screenWidth - 64 + 20), -20);
    }

    private void displayScores() {
        this.dbg.translate(this.screenWidth / 6, this.screenHeight / 6);
        int scoresWidth = this.screenWidth / 6 * 4;
        int scoresHeight = this.screenHeight / 6 * 4;
        this.dbg.setColor(new Color(100, 100, 100, 200));
        this.dbg.fillRect(0, 0, scoresWidth, scoresHeight);
        this.dbg.setColor(Color.black);
        this.dbg.drawRect(0, 0, scoresWidth, scoresHeight);
        Iterator<Player> playersIterator = this.gameController.getPlayersIterator();
        int i = 1;
        while (playersIterator.hasNext()) {
            Player player = playersIterator.next();
            this.dbg.setPaint(player.getColor());
            this.dbg.setFont(new Font("SansSerif", 1, 18));
            this.dbg.drawString(player.getName(), 10, 30 * i);
            this.dbg.drawString(Integer.toString(player.getScore()), scoresWidth / 2, 30 * i);
            ++i;
        }
        this.dbg.translate(-this.screenWidth / 6, -this.screenHeight / 6);
    }

    public void displayStartScreen() {
        this.dbg.setColor(Color.LIGHT_GRAY);
        this.dbg.fill(this.endGameButtonRectangle);
        this.dbg.setColor(Color.black);
        this.dbg.setFont(new Font("Serif", 1, 14));
        this.dbg.drawString("Start", this.endGameButtonRectangle.x + 5, this.endGameButtonRectangle.y + 15);
        this.dbg.drawString("Game", this.endGameButtonRectangle.x + 3, this.endGameButtonRectangle.y + 30);
        this.dbg.translate(this.screenWidth / 6, this.screenHeight / 6);
        int scoresWidth = this.screenWidth / 6 * 4;
        int scoresHeight = this.screenHeight / 6 * 4;
        this.dbg.setColor(new Color(100, 100, 100, 200));
        this.dbg.fillRect(0, 0, scoresWidth, scoresHeight);
        this.dbg.setColor(Color.black);
        this.dbg.drawRect(0, 0, scoresWidth, scoresHeight);
        this.dbg.setPaint(Color.black);
        this.dbg.setFont(new Font("SansSerif", 1, 18));
        this.dbg.drawString("Enter player name: " + this.newPlayerName, 10, 30);
        Iterator<Player> playersIterator = this.gameController.getPlayersIterator();
        int i = 2;
        while (playersIterator.hasNext()) {
            Player player = playersIterator.next();
            this.dbg.setPaint(player.getColor());
            this.dbg.setFont(new Font("SansSerif", 1, 18));
            this.dbg.drawString(player.getName(), 20, 30 * i);
            ++i;
        }
        this.dbg.translate(-this.screenWidth / 6, -this.screenHeight / 6);
    }

    public void displayGameOverScreen() {
        this.displayScores();
        this.dbg.setColor(Color.LIGHT_GRAY);
        this.dbg.fill(this.endGameButtonRectangle);
        this.dbg.setColor(Color.black);
        this.dbg.setFont(new Font("Serif", 1, 14));
        this.dbg.drawString("New", this.endGameButtonRectangle.x + 5, this.endGameButtonRectangle.y + 15);
        this.dbg.drawString("Game", this.endGameButtonRectangle.x + 3, this.endGameButtonRectangle.y + 30);
    }

    public void paintLandscape(Graphics g) {
        this.dbg.translate(this.transX + this.screenWidth / 2 - 64, this.transY + this.screenHeight / 2 - 64);
        Iterator<Tile> landscapeIterator = this.gameController.getLandscapeIterator();
        while (landscapeIterator.hasNext()) {
            Tile t = landscapeIterator.next();
            g.drawImage(t.getImage(), t.getPoint().x * 128, -t.getPoint().y * 128, null);
            if (!t.hasToken()) continue;
            g.setColor(t.getToken().getColor());
            Point tokenCoordinates = t.getTokenCoordinates();
            int tokenX = tokenCoordinates.x - 10;
            int tokenY = tokenCoordinates.y - 10;
            g.fillOval(t.getPoint().x * 128 + tokenX, -t.getPoint().y * 128 + tokenY, 20, 20);
            g.setColor(Color.BLACK);
            g.drawOval(t.getPoint().x * 128 + tokenX, -t.getPoint().y * 128 + tokenY, 20, 20);
        }
        this.dbg.translate(-(this.transX + this.screenWidth / 2 - 64), -(this.transY + this.screenHeight / 2 - 64));
    }

    private void readyForTermination() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JCarcassonne.this.running = false;
            }
        });
    }

    private void handleMousePress(int xInPanel, int yInPanel, MouseEvent e) {
        if (e.getButton() == 3) {
            this.gameController.rotateNextTile();
        } else if (this.doneButtonRectangle.contains(xInPanel, yInPanel)) {
            this.gameController.endTurn();
        } else if (this.endGameButtonRectangle.contains(xInPanel, yInPanel)) {
            if (this.gameController.isGameOver()) {
                this.gameController.newGame();
                this.colorIterator = this.colorList.iterator();
            } else if (this.gameController.isGameStarting()) {
                this.gameController.startGame();
            } else {
                this.gameController.endGame();
            }
        } else if (xInPanel < this.screenWidth - 40 && yInPanel > 64) {
            xInPanel = xInPanel - this.transX - this.screenWidth / 2 + 64;
            yInPanel = yInPanel - this.transY - this.screenHeight / 2 + 64;
            int xInModel = (int)Math.floor((double)xInPanel / 128.0);
            int yInModel = (int)(-Math.floor((double)yInPanel / 128.0));
            int xInTile = xInPanel % 128;
            int yInTile = yInPanel % 128;
            xInTile = xInTile >= 0 ? xInTile : xInTile + 128;
            yInTile = yInTile >= 0 ? yInTile : yInTile + 128;
            this.gameController.handleLandscapeClick(xInModel, yInModel, xInTile, yInTile);
        }
    }

    private void handleMouseMove(int x, int y) {
        this.eastScrollFlag = x > this.screenWidth - 10;
        this.westScrollFlag = x < 10;
        this.northScrollFlag = y < 10;
        this.southScrollFlag = y > this.screenHeight - 10;
    }
}

