﻿using System.Collections.Generic;
using System.Linq;

namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes a bend read from a Guitar Pro file.
    /// A bend is defined by its type, height, and points that define how the
    /// bend is to be played
    /// </summary>
    class GPBend
    {
        // The bend height
        private int value;

        /// <summary>
        /// Default constructor
        /// </summary>
        public GPBend()
        {
            Points = new List<GPBendPoint>();
            Type = GPBendType.NONE;
            value = 0;
        }

        /// <summary>
        /// Returns a string representation of the bend
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public override string ToString()
        {
            string toReturn = "";
            GPBendPoint gbp;

            if (Type != null)
                toReturn += "Type" + ": " + Type.toString();
            toReturn += ", Value" + ": " + value;
            if (Points != null)
            {
                toReturn += "Bend poits" + ": ";

                for (int i = 0; i < Points.Count; i++)
                {
                    gbp = Points.ElementAt(i);
                    toReturn += i + ": ";
                    toReturn += gbp.toString();
                }
            }
            return toReturn;
        }

        #region Getters and setters

        public List<GPBendPoint> Points { get; private set; }

        public GPBendType Type { get; set; }

        public void setValue(int val)
        {
            value = val;
        }
        #endregion
    }
}
