﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes effects on a beat
    /// </summary>
    class GPEffectsOnBeat
    {
        // Downstroke possibly associated with this effect
        public GPDuration downStroke;

        // Presence of a rasgueado
        public bool hasRasgueado;

        // Pickstroke possibly associated with this effect
        public GPPickStroke pickStrokes;

        // Presence of a popping effect (bass guitar)
        public bool popping;

        // Presence of a slapping effect
        public bool slapping;

        // Presencing of a tapping effect
        public bool tapping;

        // Tremolo bar possibly assocated with this effect
        public GPBend tremoloBar;

        // Upstroke possibly associated with this effect
        public GPDuration upStroke;

        /// <summary>
        /// Creates a new instance of this class
        /// </summary>
        public GPEffectsOnBeat()
        {
            downStroke = null;
            hasRasgueado = false;
            pickStrokes = null;
            popping = false;
            slapping = false;
            tapping = false;
            tremoloBar = null;
            upStroke = null;
        }

        /// <summary>
        /// Returns a string representation of this effect on beat
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public string toString()
        {
            string toReturn = null;

            if (downStroke != null)
                toReturn = "downStroke" + ": " + downStroke;
            if (hasRasgueado)
                toReturn += ", hasRasgueado";
            if (pickStrokes != null)
                toReturn += ", pickStrokes" + ": " + pickStrokes.toString();
            if (popping)
                toReturn += ", popping";
            if (slapping)
                toReturn += ", slapping";
            if (tapping)
                toReturn += ", tapping";
            if (tremoloBar != null)
                toReturn += "tremoloBar" + ": " + tremoloBar;
            if (upStroke != null)
                toReturn += ", upStroke" + ": " + upStroke;

            return toReturn;
        }
    }
}
