﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class that describes a grace note
    /// </summary>
    class GPGraceNote
    {
        // The duration of the grace note
        private GPDuration duration;
        // The dynamic of the grace note
        private GPDynamic dynamic;
        // The fret number of the grace note
        private int fret;
        // The transition of the grace note
        private GPGraceNoteTransition transition;

        // Create a new grace note instance
        public GPGraceNote()
        {
            duration = GPDuration.QUARTER;
            dynamic = GPDynamic.f;
            fret = 0;
            transition = GPGraceNoteTransition.none;
        }

        public string toString()
        {
            string toReturn = "Fret: " + fret;
            toReturn += ",Dynamic: " + dynamic.toString();
            toReturn += ",Transition: " + transition.ToString();
            toReturn += ",Duration: " + duration;

            return toReturn;
        }

        #region Getters and setters
        public GPDuration Duration
        {
            set { duration = value; }
        }
        public GPDynamic Dynamic
        {
            set { dynamic = value; }
        }
        public int Fret
        {
            set { fret = value; }
        }
        public GPGraceNoteTransition Transition
        {
            set { transition = value; }
        }
        #endregion
    }
}
