﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GuitarTrainer.GuitarProComponents
{
    // Class that describes the transitions for a grace note
    class GPGraceNoteTransition
    {
        // A grace note transition is represented by an integer
        private readonly int type;

        // The types of grace note transitions that this class accepts
        public static readonly GPGraceNoteTransition none = new GPGraceNoteTransition(0);
        public static readonly GPGraceNoteTransition slide = new GPGraceNoteTransition(1);
        public static readonly GPGraceNoteTransition bend = new GPGraceNoteTransition(2);
        public static readonly GPGraceNoteTransition hammer = new GPGraceNoteTransition(3);

        // The transitions
        private static readonly GPGraceNoteTransition[] transitions = { none, slide, bend, hammer };
        // The transitions' names
        private static readonly string[] transitionsNames = { "None", "Slide", "Bend", "Hammer" };

        /// <summary>
        /// Creates a new grace note transition whoste type is the parameter 'type'
        /// </summary>
        /// <param name="type">The index of this transition</param>
        private GPGraceNoteTransition(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the grace note transition associated with the value of the parameter 'type'
        /// </summary>
        /// <param name="type">The index of the transition to look up</param>
        /// <returns>The transition the index represents</returns>
        public static GPGraceNoteTransition valueOf(int type)
        {
            return transitions[type];
        }

        /// <summary>
        /// Returns a string representation of this grace note transition
        /// </summary>
        /// <returns>The string representation of this</returns>
        public override string ToString()
        {
            return transitionsNames[type];
        }
    }
}
