﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describe a harmonic
    /// </summary>
    class GPHarmonic
    {
        private readonly int index;

        // A harmonic is represented by an integer
        private readonly int type;
        
        // This declaration must be located before any other const GPHarmonic instantiations
        private static readonly int[] harmonicValues = { 0, 1, 3, 4, 5, 15, 17, 22 };

        // Define the harmonics accepted by this class
        public static readonly GPHarmonic none = new GPHarmonic(0);
        public static readonly GPHarmonic natural = new GPHarmonic(1);
        public static readonly GPHarmonic tapped = new GPHarmonic(3);
        public static readonly GPHarmonic pitch = new GPHarmonic(4);
        public static readonly GPHarmonic semi = new GPHarmonic(5);
        public static readonly GPHarmonic artificial5 = new GPHarmonic(15);
        public static readonly GPHarmonic artificial7 = new GPHarmonic(17);
        public static readonly GPHarmonic artifical12 = new GPHarmonic(22);

        // The harmonics
        private static readonly GPHarmonic[] harmonics = { none, natural, tapped, pitch,
            semi, artificial5, artificial7, artifical12 };

        // The slides' names
        private static readonly string[] harmonicStrings = { "None", "Natural", "Tapped",
            "Pitch", "Semi", "Artificial + 5", "Artificial + 7",
            "Artificial + 12" };

        /// <summary>
        /// Creates a new harmonic whose type is the value of the argument 'value'
        /// </summary>
        /// <param name="value">The index of this harmonic</param>
        private GPHarmonic(int value)
        {
            type = value;
            index = indexOf(type);
        }

        /// <summary>
        /// Returns the index of the harm onic of type parameter 'value'
        /// </summary>
        /// <param name="value">The index of the value</param>
        /// <returns>The index of the value</returns>
        private static int indexOf(int value)
        {
            bool found = false;
            int toReturn = -1;

            for (int i = harmonicValues.Length - 1; (!found) && (i >= 0); i--)
            {
                found = (harmonicValues[i] == value);
                if (found)
                    toReturn = i;
            }

            return toReturn;
        }

        /// <summary>
        /// Returns the GPHarmonic associated with the value of the parameter 'value'
        /// </summary>
        /// <param name="value">The index of the harmonic to look up</param>
        /// <returns>The harmonic the index represents</returns>
        public static GPHarmonic valueOf(int value)
        {
            GPHarmonic toReturn = null;
            int i = indexOf(value);
            if (i >= 0)
                toReturn = harmonics[i];

            return toReturn;
        }

        /// <summary>
        /// Returns a string representation of this harmonic
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public override string ToString()
        {
            string toReturn = "Harmonic (type = " + type + ", index = " +
                index + ")";
            if ((index >= 0) && (index < harmonicValues.Length))
                toReturn = harmonicStrings[index];

            return toReturn;
        }
    }
}
