﻿using System;

namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class that describes the measure of a piece
    /// </summary>
    class GPMeasure
    {
        // Resence of a double bar
        public bool hasDoubleBar;

        // The marker possible associated with this measure
        public GPMarker marker;

        // Presence of the beginning of a repeat sign
        public bool repeatStart;

        // Numerator of the measure
        private int numerator;

        // Denominator of the measure
        private int denominator;

        // The number of the measure
        private int measureNumber;

        // The number of alternate endings of the measure
        private int numberOfAlternateEndings;

        // The number of repititions of the measure
        private int numberOfRepititions;

        // The tonality of this measure
        private GPKey tonality;

        /// <summary>
        /// Creates a new measure with the same numerator/denominator and tonality
        /// </summary>
        /// <param name="original">The original measure to copy</param>
        public GPMeasure(GPMeasure original)
        {
            hasDoubleBar = false;
            marker = null;
            numberOfAlternateEndings = 0;
            numberOfRepititions = 0;
            repeatStart = false;

            if (original != null)
            {
                denominator = original.denominator;
                numerator = original.numerator;
                tonality = original.Tonality;
            }
            else
            {
                denominator = 0;
                numerator = 0;
                tonality = GPKey.c;
            }
        }

        /// <summary>
        /// Determines if the object is equal to this
        /// </summary>
        /// <param name="o">The object to test</param>
        /// <returns>Returns true if the given object is equal to this object</returns>
        public override bool Equals(Object o)
        {
            bool toReturn = false;
            GPMeasure other;

            if ((o != null) && (o.GetType().IsInstanceOfType(this)))
            {
                other = (GPMeasure)o;

                toReturn = (hasDoubleBar == other.hasDoubleBar);
                toReturn = toReturn && (repeatStart == other.repeatStart);
                toReturn = toReturn && (denominator == other.denominator);
                toReturn = toReturn && (numerator == other.numerator);
                toReturn = toReturn && (measureNumber == other.measureNumber);
                toReturn = toReturn && (numberOfAlternateEndings == other.numberOfAlternateEndings);
                toReturn = toReturn && (numberOfRepititions == other.numberOfRepititions);
            }

            return toReturn;
        }

        /// <summary>
        /// The string representation of this
        /// </summary>
        /// <returns>Returns the string representation of this</returns>
        public override string ToString()
        {
            string toReturn = "Time signature: " + numerator + "/" + denominator;
            if (repeatStart)
                toReturn += ", Repeat start";
            if (numberOfRepititions > 0)
                toReturn += ", Repeat end (" + numberOfRepititions + "X)";
            if (numberOfAlternateEndings > 0)
                toReturn += ", Alternate ending: " + numberOfAlternateEndings;
            if (marker != null)
                toReturn += ", Marker: " + marker;
            toReturn += ", Tonality: " + tonality;
            if (hasDoubleBar)
                toReturn += ", Double bar " + hasDoubleBar;

            return toReturn;
        }

        #region Getters and setters

        public bool RepeatStart
        {
            get { return repeatStart; }
        }
        public int Numerator
        {
            get { return numerator; }
            set { numerator = value; }
        }
        public int Denominator
        {
            get { return denominator; }
            set { denominator = value; }
        }
        public int MeasureNumber
        {
            get { return measureNumber; }
            set { measureNumber = value; }
        }
        public int NumberOfAlternateEndings
        {
            set { numberOfAlternateEndings = value; }
        }
        public int NumberOfRepititions
        {
            get { return numberOfRepititions; }
            set { numberOfRepititions = value; }
        }
        public GPKey Tonality
        {
            get { return tonality; }
            set { tonality = value; }
        }
        #endregion 
    }
}
