﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Describes a pair of a measure and a track
    /// </summary>
    class GPMeasureTrackPair
    {
        // The beats present in the measure-track pair
        private readonly List<GPBeat> beats;

        /// <summary>
        /// Creates a new measure-track pair
        /// </summary>
        public GPMeasureTrackPair()
        {
            beats = new List<GPBeat>();
        }

        /// <summary>
        /// Tests whether or not the argument is equal to this
        /// </summary>
        /// <param name="o">The object to test</param>
        /// <returns>Returns true if the given object equals this</returns>
        public override bool Equals(Object o)
        {
            GPMeasureTrackPair other;
            bool toReturn = false;

            if ((o != null) && (o.GetType().IsInstanceOfType(this)))
            {
                other = (GPMeasureTrackPair)o;
                toReturn = beats.Equals(other.beats);
            }

            return toReturn;
        }

        /// <summary>
        /// The string representation of this
        /// </summary>
        /// <returns>The string representation of this</returns>
        public override string ToString()
        {
            string toReturn = "Measure/Track Pair - BEGIN\n";

            if (beats != null)
            {
                for (int i = 0; i < beats.Count; i++)
                {
                    toReturn += "\tBeat #" + i + "\n";
                    toReturn += beats.ElementAt(i) + "\n";
                }
            }
            toReturn += "\tMeasure/Track Pair - END" + "\n";

            return toReturn;
        }

        public List<GPBeat> Beats
        {
            get { return beats; }
        }
    }
}
