﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class that describes a mix table element
    /// </summary>
    class GPMixTableElement
    {
        // Whether the change applies to all tracks
        public bool applyToAllTracks;

        // The duration of the change in beats
        private int changeDuration;

        // The new value of the element
        private int newValue;

        /// <summary>
        /// Creates a new mix table element
        /// </summary>
        public GPMixTableElement()
        {
            applyToAllTracks = false;
            changeDuration = 0;
            newValue = 0;
        }

        /// <summary>
        /// Returns a string representation of this mix table element
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public override string ToString()
        {
            string toReturn = "";
            if (applyToAllTracks)
                toReturn = "applyToAllTracks: " + applyToAllTracks + ", ";
            toReturn += "changeDuration: " + changeDuration;
            toReturn += ", newValue: " + newValue;

            return toReturn;
        }

        #region Getters and setters
        public int ChangeDuration
        {
            set { changeDuration = value; }
        }
        public int NewValue
        {
            get { return newValue; }
            set { newValue = value; }
        }
        #endregion
    }
}
