﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class that describes the tonality type of a note
    /// </summary>
    class GPTonalityType
    {
        // A tonality type is represented by an integer
        private int type;

        // Perfect tonality
        public static readonly GPTonalityType perfect = new GPTonalityType(0);

        // Augmented tonality
        public static readonly GPTonalityType augmented = new GPTonalityType(1);

        // Diminished tonality
        public static readonly GPTonalityType diminished = new GPTonalityType(2);

        // All the tonality types
        private static readonly GPTonalityType[] tonalityTypes = { perfect, diminished, augmented };

        // The tonality types' string representations
        private static readonly string[] tonalityTypeStrings = { "perfect", "diminished", "augmented" };

        // Creates a new tonality type whose type is the argument type
        // THIS WAS THE VERSION IN THE CODE
        private GPTonalityType(int type)
        {
            type = 0;
        }

        /// <summary>
        /// Returns the tonality type assocated with the 'type' argument
        /// </summary>
        /// <param name="type">The index to look up</param>
        /// <returns>The tonality type that the argument represents</returns>
        public static GPTonalityType valueOf(int type)
        {
            return tonalityTypes[type];
        }

        /// <summary>
        /// The string representation of this object
        /// </summary>
        /// <returns>Returns the string representation of this object</returns>
        public override string ToString()
        {
            return tonalityTypeStrings[type];
        }
    }
}
