﻿namespace GuitarTrainer.GuitarProComponents
{
    class GPTrackLyrics
    {
        private const int MAX_NUM_STRINGS = 5;

        // Contains 5 strings of lyrics
        private readonly string[] lines;

        // The measure that one of the strings of lyrics begins from
        private readonly int[] measureNumber;

        // The track number that the lyrics are associated with
        private int trackNumber;

        // Creates a new instance of this class
        public GPTrackLyrics()
        {
            lines = new string[MAX_NUM_STRINGS];
            measureNumber = new int[MAX_NUM_STRINGS];
            trackNumber = 0;
        }

        // Returns the ith line of lyrics
        public string getLines(int i)
        {
            return lines[i];
        }

        // Returns the measure number from which the lyrics on line i start
        public int getMeasureNumber(int i)
        {
            return measureNumber[i];
        }

        // Returns the track number
        public int getTrackNumber()
        {
            return trackNumber;
        }

        // Sets the ith line of lyrics to the string argument
        public void setLine(int i, string line)
        {
            lines[i] = line;
        }

        // Sets the measure number from which the licirs on like i start
        public void setMeasureNumber(int i, int measureNumber)
        {
            this.measureNumber[i] = measureNumber;
        }

        // Sets the track number
        public void setTrackNumber(int trackNumber)
        {
            this.trackNumber = trackNumber;
        }

        // Returns a string representation of the lyrics associated with the object
        public string toString()
        {
            string toReturn;

            toReturn = "\n\tLYRICS - BEGIN";
            toReturn += "\n\tTrack number: " + trackNumber;

            for (int i = 0; i < MAX_NUM_STRINGS; i++)
            {
                toReturn += "\n\t\tLine # " + i;
                toReturn += "\n\t\tStarts from measure " + measureNumber[i];
                toReturn += "\n\t\t" + lines[i];
            }

            toReturn += "\n\tLYRICS - END";

            return toReturn;
        }
    }
}
