﻿using System;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class RepeatedSongPhraseImpl : IRepeatedSongPhrase
    {
        private readonly ISongPhrase phrase;
        private readonly int repeatCount;

        /// <summary>
        /// Constructor to use
        /// </summary>
        /// <param name="phrase">The phrase that is repeated</param>
        /// <param name="repeatCount">The number of times the phrase is repeated</param>
        public RepeatedSongPhraseImpl(ISongPhrase phrase, int repeatCount)
        {
            this.phrase = phrase;
            this.repeatCount=repeatCount;
        }

        #region IRepeatedSongPhrase Members

        public ISongPhrase getPhrase()
        {
            return phrase;
        }

        public int getRepeatCount()
        {
            return repeatCount;
        }

        #endregion

        #region ISongPhrase Members

        public int getScoreMeasureCount()
        {
            return phrase.getScoreMeasureCount();
        }

        public ISongMeasure getScoreMeasure(int measure)
        {
            int sc = phrase.getScoreMeasureCount();
            if ((measure < 0) || (measure >= sc))
                throw new IndexOutOfRangeException();
            
            return phrase.getScoreMeasure(measure);
        }

        public int getPerformanceMeasureCount()
        {
            return (repeatCount + 1) * phrase.getPerformanceMeasureCount();
        }

        public ISongMeasure getPerformanceMeasure(int measure)
        {
            int pc = phrase.getPerformanceMeasureCount();
            if ((measure < 0) || (measure >= (repeatCount + 1) * pc))
                throw new IndexOutOfRangeException();
            
            return phrase.getPerformanceMeasure(measure % pc);
        }

        #endregion
    }
}
