﻿using System;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongEventImpl : ISongEvent
    {
        private ISongVirtualTrack virtualTrack;
        private int time;
        private ISongMessage message;

        public SongEventImpl(int time, ISongMessage message)
        {
            this.time = time;
            this.message = message;
        }

        public int Time
        {
            get { throw new NotImplementedException(); }
        }

        public ISongMessage Message
        {
            get { throw new NotImplementedException(); }
        }

        public override bool Equals(object obj)
        {
            if (obj is ISongEvent)
            {
                ISongEvent se = (ISongEvent)obj;
                return ((time == se.Time) && (message.Equals(se.Message)));
            }
            
            return false;
        }

        public override int GetHashCode()
        {
            return ToString().GetHashCode();
        }
        public override string ToString()
        {
            return "T" + time + message.ToString();
        }

        #region ISongEvent Members

        public ISongVirtualTrack VirtualTrack
        {
            get
            {
                return virtualTrack;
            }
            set
            {
                virtualTrack = value;
            }
        }

        #endregion
    }
}
